/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk.filter;

import java.util.Collection;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.revwalk.filter.OrRevFilter$Binary;
import org.eclipse.jgit.revwalk.filter.OrRevFilter$List;
import org.eclipse.jgit.revwalk.filter.RevFilter;

public abstract class OrRevFilter
extends RevFilter {
    public static RevFilter create(RevFilter revFilter, RevFilter revFilter2) {
        if (revFilter == ALL || revFilter2 == ALL) {
            return ALL;
        }
        return new OrRevFilter$Binary(revFilter, revFilter2);
    }

    public static RevFilter create(RevFilter[] revFilterArray) {
        if (revFilterArray.length == 2) {
            return OrRevFilter.create(revFilterArray[0], revFilterArray[1]);
        }
        if (revFilterArray.length < 2) {
            throw new IllegalArgumentException(JGitText.get().atLeastTwoFiltersNeeded);
        }
        RevFilter[] revFilterArray2 = new RevFilter[revFilterArray.length];
        System.arraycopy(revFilterArray, 0, revFilterArray2, 0, revFilterArray.length);
        return new OrRevFilter$List(revFilterArray2);
    }

    public static RevFilter create(Collection collection) {
        if (collection.size() < 2) {
            throw new IllegalArgumentException(JGitText.get().atLeastTwoFiltersNeeded);
        }
        RevFilter[] revFilterArray = new RevFilter[collection.size()];
        collection.toArray(revFilterArray);
        if (revFilterArray.length == 2) {
            return OrRevFilter.create(revFilterArray[0], revFilterArray[1]);
        }
        return new OrRevFilter$List(revFilterArray);
    }
}

