/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk.filter;

import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.OrRevFilter;
import org.eclipse.jgit.revwalk.filter.RevFilter;

class OrRevFilter$List
extends OrRevFilter {
    private final RevFilter[] subfilters;
    private final boolean requiresCommitBody;

    OrRevFilter$List(RevFilter[] revFilterArray) {
        this.subfilters = revFilterArray;
        boolean bl2 = false;
        for (RevFilter revFilter : this.subfilters) {
            bl2 |= revFilter.requiresCommitBody();
        }
        this.requiresCommitBody = bl2;
    }

    @Override
    public boolean include(RevWalk revWalk, RevCommit revCommit) {
        for (RevFilter revFilter : this.subfilters) {
            if (!revFilter.include(revWalk, revCommit)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean requiresCommitBody() {
        return this.requiresCommitBody;
    }

    @Override
    public RevFilter clone() {
        RevFilter[] revFilterArray = new RevFilter[this.subfilters.length];
        for (int i2 = 0; i2 < revFilterArray.length; ++i2) {
            revFilterArray[i2] = this.subfilters[i2].clone();
        }
        return new OrRevFilter$List(revFilterArray);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        for (int i2 = 0; i2 < this.subfilters.length; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(" OR ");
            }
            stringBuilder.append(this.subfilters[i2].toString());
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

