/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk.filter;

import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.filter.MessageRevFilter$PatternSearch;
import org.eclipse.jgit.revwalk.filter.MessageRevFilter$SubStringSearch;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.revwalk.filter.SubStringRevFilter;
import org.eclipse.jgit.util.RawCharSequence;
import org.eclipse.jgit.util.RawParseUtils;

public class MessageRevFilter {
    public static RevFilter create(String string) {
        if (string.length() == 0) {
            throw new IllegalArgumentException(JGitText.get().cannotMatchOnEmptyString);
        }
        if (SubStringRevFilter.safe(string)) {
            return new MessageRevFilter$SubStringSearch(string);
        }
        return new MessageRevFilter$PatternSearch(string);
    }

    private MessageRevFilter() {
    }

    static RawCharSequence textFor(RevCommit revCommit) {
        byte[] byArray = revCommit.getRawBuffer();
        int n2 = RawParseUtils.commitMessage(byArray, 0);
        if (n2 < 0) {
            return RawCharSequence.EMPTY;
        }
        return new RawCharSequence(byArray, n2, byArray.length);
    }
}

