/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk.filter;

import org.eclipse.jgit.errors.StopWalkException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;

public class MaxCountRevFilter
extends RevFilter {
    private int maxCount;
    private int count = 0;

    public static RevFilter create(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException(JGitText.get().maxCountMustBeNonNegative);
        }
        return new MaxCountRevFilter(n2);
    }

    private MaxCountRevFilter(int n2) {
        this.maxCount = n2;
    }

    @Override
    public boolean include(RevWalk revWalk, RevCommit revCommit) {
        ++this.count;
        if (this.count > this.maxCount) {
            throw StopWalkException.INSTANCE;
        }
        return true;
    }

    @Override
    public RevFilter clone() {
        return new MaxCountRevFilter(this.maxCount);
    }
}

