/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk.filter;

import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.filter.CommitterRevFilter$PatternSearch;
import org.eclipse.jgit.revwalk.filter.CommitterRevFilter$SubStringSearch;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.revwalk.filter.SubStringRevFilter;
import org.eclipse.jgit.util.RawCharSequence;
import org.eclipse.jgit.util.RawParseUtils;

public class CommitterRevFilter {
    public static RevFilter create(String string) {
        if (string.length() == 0) {
            throw new IllegalArgumentException(JGitText.get().cannotMatchOnEmptyString);
        }
        if (SubStringRevFilter.safe(string)) {
            return new CommitterRevFilter$SubStringSearch(string);
        }
        return new CommitterRevFilter$PatternSearch(string);
    }

    private CommitterRevFilter() {
    }

    static RawCharSequence textFor(RevCommit revCommit) {
        byte[] byArray = revCommit.getRawBuffer();
        int n2 = RawParseUtils.committer(byArray, 0);
        if (n2 < 0) {
            return RawCharSequence.EMPTY;
        }
        int n3 = RawParseUtils.nextLF(byArray, n2, '>');
        return new RawCharSequence(byArray, n2, n3);
    }
}

