/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk.filter;

import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.filter.AuthorRevFilter$PatternSearch;
import org.eclipse.jgit.revwalk.filter.AuthorRevFilter$SubStringSearch;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.revwalk.filter.SubStringRevFilter;
import org.eclipse.jgit.util.RawCharSequence;
import org.eclipse.jgit.util.RawParseUtils;

public class AuthorRevFilter {
    public static RevFilter create(String string) {
        if (string.length() == 0) {
            throw new IllegalArgumentException(JGitText.get().cannotMatchOnEmptyString);
        }
        if (SubStringRevFilter.safe(string)) {
            return new AuthorRevFilter$SubStringSearch(string);
        }
        return new AuthorRevFilter$PatternSearch(string);
    }

    private AuthorRevFilter() {
    }

    static RawCharSequence textFor(RevCommit revCommit) {
        byte[] byArray = revCommit.getRawBuffer();
        int n2 = RawParseUtils.author(byArray, 0);
        if (n2 < 0) {
            return RawCharSequence.EMPTY;
        }
        int n3 = RawParseUtils.nextLF(byArray, n2, '>');
        return new RawCharSequence(byArray, n2, n3);
    }
}

