/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk.filter;

import java.util.Collection;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.revwalk.filter.AndRevFilter$Binary;
import org.eclipse.jgit.revwalk.filter.AndRevFilter$List;
import org.eclipse.jgit.revwalk.filter.RevFilter;

public abstract class AndRevFilter
extends RevFilter {
    public static RevFilter create(RevFilter revFilter, RevFilter revFilter2) {
        if (revFilter == ALL) {
            return revFilter2;
        }
        if (revFilter2 == ALL) {
            return revFilter;
        }
        return new AndRevFilter$Binary(revFilter, revFilter2);
    }

    public static RevFilter create(RevFilter[] revFilterArray) {
        if (revFilterArray.length == 2) {
            return AndRevFilter.create(revFilterArray[0], revFilterArray[1]);
        }
        if (revFilterArray.length < 2) {
            throw new IllegalArgumentException(JGitText.get().atLeastTwoFiltersNeeded);
        }
        RevFilter[] revFilterArray2 = new RevFilter[revFilterArray.length];
        System.arraycopy(revFilterArray, 0, revFilterArray2, 0, revFilterArray.length);
        return new AndRevFilter$List(revFilterArray2);
    }

    public static RevFilter create(Collection collection) {
        if (collection.size() < 2) {
            throw new IllegalArgumentException(JGitText.get().atLeastTwoFiltersNeeded);
        }
        RevFilter[] revFilterArray = new RevFilter[collection.size()];
        collection.toArray(revFilterArray);
        if (revFilterArray.length == 2) {
            return AndRevFilter.create(revFilterArray[0], revFilterArray[1]);
        }
        return new AndRevFilter$List(revFilterArray);
    }
}

