/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.util.List;
import org.eclipse.jgit.diff.DiffConfig;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffEntry$ChangeType;
import org.eclipse.jgit.diff.RenameDetector;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.FollowFilter;
import org.eclipse.jgit.revwalk.RenameCallback;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public class TreeRevFilter
extends RevFilter {
    private static final int PARSED = 1;
    private static final int UNINTERESTING = 4;
    private final int rewriteFlag;
    private final TreeWalk pathFilter;

    public TreeRevFilter(RevWalk revWalk, TreeFilter treeFilter) {
        this(revWalk, treeFilter, 0);
    }

    TreeRevFilter(RevWalk revWalk, TreeFilter treeFilter, int n2) {
        this.pathFilter = new TreeWalk(revWalk.reader);
        this.pathFilter.setFilter(treeFilter);
        this.pathFilter.setRecursive(treeFilter.shouldBeRecursive());
        this.rewriteFlag = n2;
    }

    @Override
    public RevFilter clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean include(RevWalk revWalk, RevCommit revCommit) {
        int n2;
        int n3;
        int n4;
        Object object;
        int n5;
        RevCommit[] revCommitArray = revCommit.parents;
        int n6 = revCommitArray.length;
        TreeWalk treeWalk = this.pathFilter;
        AnyObjectId[] anyObjectIdArray = new ObjectId[n6 + 1];
        for (n5 = 0; n5 < n6; ++n5) {
            object = revCommit.parents[n5];
            if ((((RevCommit)object).flags & 1) == 0) {
                ((RevCommit)object).parseHeaders(revWalk);
            }
            anyObjectIdArray[n5] = ((RevCommit)object).getTree();
        }
        anyObjectIdArray[n6] = revCommit.getTree();
        treeWalk.reset(anyObjectIdArray);
        if (n6 == 1) {
            n5 = 0;
            int n7 = 0;
            while (treeWalk.next()) {
                ++n5;
                if (treeWalk.getRawMode(0) != 0 || treeWalk.getRawMode(1) == 0) break;
                ++n7;
            }
            if (n5 == 0) {
                revCommit.flags |= this.rewriteFlag;
                return false;
            }
            if (n7 > 0 && treeWalk.getFilter() instanceof FollowFilter) {
                this.updateFollowFilter((ObjectId[])anyObjectIdArray, ((FollowFilter)treeWalk.getFilter()).cfg);
            }
            return true;
        }
        if (n6 == 0) {
            if (treeWalk.next()) {
                return true;
            }
            revCommit.flags |= this.rewriteFlag;
            return false;
        }
        int[] nArray = new int[n6];
        object = new int[n6];
        while (treeWalk.next()) {
            n4 = treeWalk.getRawMode(n6);
            for (n3 = 0; n3 < n6; ++n3) {
                n2 = treeWalk.getRawMode(n3);
                if (n4 == n2 && treeWalk.idEqual(n3, n6)) continue;
                int n8 = n3;
                nArray[n8] = nArray[n8] + 1;
                if (n2 != 0 || n4 == 0) continue;
                Object object2 = object;
                int n9 = n3;
                object2[n9] = object2[n9] + true;
            }
        }
        n4 = 0;
        n3 = 0;
        for (n2 = 0; n2 < n6; ++n2) {
            if (nArray[n2] == 0) {
                RevCommit revCommit2 = revCommitArray[n2];
                if ((revCommit2.flags & 4) != 0) {
                    n4 = 1;
                    continue;
                }
                revCommit.flags |= this.rewriteFlag;
                revCommit.parents = new RevCommit[]{revCommit2};
                return false;
            }
            if (nArray[n2] == object[n2]) {
                treeWalk.reset((AnyObjectId)revCommitArray[n2].getTree());
                if (!treeWalk.next()) {
                    revCommitArray[n2].parents = RevCommit.NO_PARENTS;
                }
            }
            n3 = 1;
        }
        if (n3 != 0 && n4 == 0) {
            return true;
        }
        revCommit.flags |= this.rewriteFlag;
        return false;
    }

    @Override
    public boolean requiresCommitBody() {
        return false;
    }

    private void updateFollowFilter(ObjectId[] objectIdArray, DiffConfig diffConfig) {
        TreeWalk treeWalk = this.pathFilter;
        FollowFilter followFilter = (FollowFilter)treeWalk.getFilter();
        treeWalk.setFilter(TreeFilter.ANY_DIFF);
        treeWalk.reset(objectIdArray);
        List list = DiffEntry.scan(treeWalk);
        RenameDetector renameDetector = new RenameDetector(treeWalk.getObjectReader(), diffConfig);
        renameDetector.addAll(list);
        list = renameDetector.compute();
        FollowFilter followFilter2 = followFilter;
        for (DiffEntry diffEntry : list) {
            if (!TreeRevFilter.isRename(diffEntry) || !diffEntry.getNewPath().equals(followFilter.getPath())) continue;
            followFilter2 = FollowFilter.create(diffEntry.getOldPath(), diffConfig);
            RenameCallback renameCallback = followFilter.getRenameCallback();
            if (renameCallback == null) break;
            renameCallback.renamed(diffEntry);
            followFilter2.setRenameCallback(renameCallback);
            break;
        }
        treeWalk.setFilter(followFilter2);
    }

    private static boolean isRename(DiffEntry diffEntry) {
        return diffEntry.getChangeType() == DiffEntry$ChangeType.RENAME || diffEntry.getChangeType() == DiffEntry$ChangeType.COPY;
    }
}

