/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import org.eclipse.jgit.revwalk.BlockRevQueue;
import org.eclipse.jgit.revwalk.FIFORevQueue;
import org.eclipse.jgit.revwalk.Generator;
import org.eclipse.jgit.revwalk.RevCommit;

class TopoSortGenerator
extends Generator {
    private static final int TOPO_DELAY = 32;
    private final FIFORevQueue pending;
    private final int outputType;

    TopoSortGenerator(Generator generator) {
        super(generator.firstParent);
        RevCommit revCommit;
        this.pending = new FIFORevQueue(this.firstParent);
        this.outputType = generator.outputType() | 8;
        generator.shareFreeList(this.pending);
        while ((revCommit = generator.next()) != null) {
            for (RevCommit revCommit2 : revCommit.parents) {
                ++revCommit2.inDegree;
                if (this.firstParent) break;
            }
            this.pending.add(revCommit);
        }
    }

    @Override
    int outputType() {
        return this.outputType;
    }

    @Override
    void shareFreeList(BlockRevQueue blockRevQueue) {
        blockRevQueue.shareFreeList(this.pending);
    }

    @Override
    RevCommit next() {
        RevCommit revCommit;
        while (true) {
            if ((revCommit = this.pending.next()) == null) {
                return null;
            }
            if (revCommit.inDegree <= 0) break;
            revCommit.flags |= 0x20;
        }
        for (RevCommit revCommit2 : revCommit.parents) {
            if (--revCommit2.inDegree == 0 && (revCommit2.flags & 0x20) != 0) {
                revCommit2.flags &= 0xFFFFFFDF;
                this.pending.unpop(revCommit2);
            }
            if (this.firstParent) break;
        }
        return revCommit;
    }
}

