/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import org.eclipse.jgit.revwalk.BlockRevQueue;
import org.eclipse.jgit.revwalk.FIFORevQueue;
import org.eclipse.jgit.revwalk.Generator;
import org.eclipse.jgit.revwalk.RevCommit;

class TopoNonIntermixSortGenerator
extends Generator {
    private static final int TOPO_QUEUED = 64;
    private final FIFORevQueue pending;
    private final int outputType;

    TopoNonIntermixSortGenerator(Generator generator) {
        super(generator.firstParent);
        RevCommit revCommit;
        this.pending = new FIFORevQueue(this.firstParent);
        this.outputType = generator.outputType() | 8;
        generator.shareFreeList(this.pending);
        while ((revCommit = generator.next()) != null) {
            if ((revCommit.flags & 0x40) == 0) {
                for (RevCommit revCommit2 : revCommit.parents) {
                    ++revCommit2.inDegree;
                    if (this.firstParent) break;
                }
            }
            revCommit.flags |= 0x40;
            this.pending.add(revCommit);
        }
    }

    @Override
    int outputType() {
        return this.outputType;
    }

    @Override
    void shareFreeList(BlockRevQueue blockRevQueue) {
        blockRevQueue.shareFreeList(this.pending);
    }

    @Override
    RevCommit next() {
        RevCommit revCommit;
        do {
            if ((revCommit = this.pending.next()) != null) continue;
            return null;
        } while (revCommit.inDegree > 0 || (revCommit.flags & 0x40) == 0);
        for (RevCommit revCommit2 : revCommit.parents) {
            if (--revCommit2.inDegree == 0 && (revCommit2.flags & 0x40) != 0) {
                this.pending.unpop(revCommit2);
            }
            if (this.firstParent) break;
        }
        revCommit.flags &= 0xFFFFFFBF;
        return revCommit;
    }
}

