/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.text.MessageFormat;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.revwalk.AbstractRevQueue;
import org.eclipse.jgit.revwalk.BoundaryGenerator;
import org.eclipse.jgit.revwalk.DateRevQueue;
import org.eclipse.jgit.revwalk.DelayRevQueue;
import org.eclipse.jgit.revwalk.DepthGenerator;
import org.eclipse.jgit.revwalk.DepthWalk;
import org.eclipse.jgit.revwalk.FIFORevQueue;
import org.eclipse.jgit.revwalk.FixUninterestingGenerator;
import org.eclipse.jgit.revwalk.Generator;
import org.eclipse.jgit.revwalk.LIFORevQueue;
import org.eclipse.jgit.revwalk.MergeBaseGenerator;
import org.eclipse.jgit.revwalk.ObjectWalk;
import org.eclipse.jgit.revwalk.PendingGenerator;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.RewriteGenerator;
import org.eclipse.jgit.revwalk.TopoNonIntermixSortGenerator;
import org.eclipse.jgit.revwalk.TopoSortGenerator;
import org.eclipse.jgit.revwalk.TreeRevFilter;
import org.eclipse.jgit.revwalk.filter.AndRevFilter;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

class StartGenerator
extends Generator {
    private final RevWalk walker;

    StartGenerator(RevWalk revWalk) {
        super(revWalk.isFirstParent());
        this.walker = revWalk;
    }

    @Override
    int outputType() {
        return 0;
    }

    @Override
    RevCommit next() {
        Generator generator;
        RevWalk revWalk = this.walker;
        RevFilter revFilter = revWalk.getRevFilter();
        TreeFilter treeFilter = revWalk.getTreeFilter();
        AbstractRevQueue abstractRevQueue = this.walker.queue;
        if (revFilter == RevFilter.MERGE_BASE) {
            if (treeFilter != TreeFilter.ALL) {
                throw new IllegalStateException(MessageFormat.format(JGitText.get().cannotCombineTreeFilterWithRevFilter, treeFilter, revFilter));
            }
            if (revWalk.isFirstParent()) {
                throw new IllegalStateException(JGitText.get().cannotFindMergeBaseUsingFirstParent);
            }
            MergeBaseGenerator mergeBaseGenerator = new MergeBaseGenerator(revWalk);
            this.walker.pending = mergeBaseGenerator;
            this.walker.queue = AbstractRevQueue.EMPTY_QUEUE;
            mergeBaseGenerator.init(abstractRevQueue);
            return mergeBaseGenerator.next();
        }
        boolean bl2 = abstractRevQueue.anybodyHasFlag(4);
        boolean bl3 = this.walker.hasRevSort(RevSort.BOUNDARY);
        if (!bl3 && this.walker instanceof ObjectWalk) {
            bl3 = true;
        }
        if (bl3 && !bl2) {
            bl3 = false;
        }
        int n2 = 0;
        DateRevQueue dateRevQueue = abstractRevQueue instanceof DateRevQueue ? (DateRevQueue)abstractRevQueue : new DateRevQueue(abstractRevQueue);
        if (treeFilter != TreeFilter.ALL) {
            int n3;
            if (revWalk.getRewriteParents()) {
                n2 |= 6;
                n3 = 8;
            } else {
                n3 = 0;
            }
            revFilter = AndRevFilter.create(new TreeRevFilter(revWalk, treeFilter, n3), revFilter);
        }
        this.walker.queue = abstractRevQueue;
        if (this.walker instanceof DepthWalk) {
            DepthWalk depthWalk = (DepthWalk)((Object)this.walker);
            generator = new DepthGenerator(depthWalk, dateRevQueue);
        } else {
            generator = new PendingGenerator(revWalk, dateRevQueue, revFilter, n2);
            if (this.walker.hasRevSort(RevSort.BOUNDARY)) {
                ((PendingGenerator)generator).canDispose = false;
            }
        }
        if ((generator.outputType() & 4) != 0) {
            generator = new FIFORevQueue(generator);
            generator = new RewriteGenerator(generator);
        }
        if (this.walker.hasRevSort(RevSort.TOPO) && this.walker.hasRevSort(RevSort.TOPO_KEEP_BRANCH_TOGETHER)) {
            throw new IllegalStateException(JGitText.get().cannotCombineTopoSortWithTopoKeepBranchTogetherSort);
        }
        if (this.walker.hasRevSort(RevSort.TOPO) && (generator.outputType() & 8) == 0) {
            generator = new TopoSortGenerator(generator);
        } else if (this.walker.hasRevSort(RevSort.TOPO_KEEP_BRANCH_TOGETHER) && (generator.outputType() & 8) == 0) {
            generator = new TopoNonIntermixSortGenerator(generator);
        }
        if (this.walker.hasRevSort(RevSort.REVERSE)) {
            generator = new LIFORevQueue(generator);
        }
        if (bl3) {
            generator = new BoundaryGenerator(revWalk, generator);
        } else if (bl2) {
            if (dateRevQueue.peek() != null) {
                generator = new DelayRevQueue(generator);
            }
            generator = new FixUninterestingGenerator(generator);
        }
        revWalk.pending = generator;
        return generator.next();
    }
}

