/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import org.eclipse.jgit.revwalk.BlockRevQueue;
import org.eclipse.jgit.revwalk.Generator;
import org.eclipse.jgit.revwalk.RevCommit;

class RewriteGenerator
extends Generator {
    private static final int REWRITE = 8;
    private static final int DUPLICATE = 16;
    private final Generator source;

    RewriteGenerator(Generator generator) {
        super(generator.firstParent);
        this.source = generator;
    }

    @Override
    void shareFreeList(BlockRevQueue blockRevQueue) {
        this.source.shareFreeList(blockRevQueue);
    }

    @Override
    int outputType() {
        return this.source.outputType() & 0xFFFFFFFB;
    }

    @Override
    RevCommit next() {
        RevCommit revCommit = this.source.next();
        if (revCommit == null) {
            return null;
        }
        boolean bl2 = false;
        RevCommit[] revCommitArray = revCommit.parents;
        int n2 = revCommitArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            RevCommit revCommit2 = revCommitArray[i2];
            RevCommit revCommit3 = this.rewrite(revCommit2);
            if (this.firstParent) {
                revCommit.parents = revCommit3 == null ? RevCommit.NO_PARENTS : new RevCommit[]{revCommit3};
                return revCommit;
            }
            if (revCommit2 == revCommit3) continue;
            revCommitArray[i2] = revCommit3;
            bl2 = true;
        }
        if (bl2) {
            revCommit.parents = this.cleanup(revCommitArray);
        }
        return revCommit;
    }

    private RevCommit rewrite(RevCommit revCommit) {
        RevCommit[] revCommitArray;
        while ((revCommitArray = revCommit.parents).length <= 1) {
            if ((revCommit.flags & 4) != 0) {
                return revCommit;
            }
            if ((revCommit.flags & 8) == 0) {
                return revCommit;
            }
            if (revCommitArray.length == 0) {
                return null;
            }
            revCommit = revCommitArray[0];
        }
        return revCommit;
    }

    private RevCommit[] cleanup(RevCommit[] revCommitArray) {
        int n2 = 0;
        for (int i2 = 0; i2 < revCommitArray.length; ++i2) {
            RevCommit[] revCommitArray2 = revCommitArray[i2];
            if (revCommitArray2 == null) continue;
            if ((revCommitArray2.flags & 0x10) != 0) {
                revCommitArray[i2] = null;
                continue;
            }
            revCommitArray2.flags |= 0x10;
            ++n2;
        }
        if (n2 == revCommitArray.length) {
            for (RevCommit revCommit : revCommitArray) {
                revCommit.flags &= 0xFFFFFFEF;
            }
            return revCommitArray;
        }
        RevCommit[] revCommitArray3 = new RevCommit[n2];
        n2 = 0;
        for (RevCommit revCommit : revCommitArray) {
            if (revCommit == null) continue;
            revCommitArray3[n2++] = revCommit;
            revCommit.flags &= 0xFFFFFFEF;
        }
        return revCommitArray3;
    }
}

