/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;

public final class RevWalkUtils {
    private RevWalkUtils() {
    }

    public static int count(RevWalk revWalk, RevCommit revCommit, RevCommit revCommit2) {
        return RevWalkUtils.find(revWalk, revCommit, revCommit2).size();
    }

    public static List find(RevWalk revWalk, RevCommit revCommit, RevCommit revCommit2) {
        revWalk.reset();
        revWalk.markStart(revCommit);
        if (revCommit2 != null) {
            revWalk.markUninteresting(revCommit2);
        }
        ArrayList<RevCommit> arrayList = new ArrayList<RevCommit>();
        for (RevCommit revCommit3 : revWalk) {
            arrayList.add(revCommit3);
        }
        return arrayList;
    }

    public static List findBranchesReachableFrom(RevCommit revCommit, RevWalk revWalk, Collection collection) {
        return RevWalkUtils.findBranchesReachableFrom(revCommit, revWalk, collection, NullProgressMonitor.INSTANCE);
    }

    public static List findBranchesReachableFrom(RevCommit revCommit, RevWalk revWalk, Collection collection, ProgressMonitor progressMonitor) {
        revCommit = revWalk.parseCommit(revCommit.getId());
        revWalk.reset();
        ArrayList<Ref> arrayList = new ArrayList<Ref>();
        progressMonitor.beginTask(JGitText.get().searchForReachableBranches, collection.size());
        int n2 = 86400;
        for (Ref ref : collection) {
            RevCommit revCommit2;
            RevObject revObject = revWalk.parseAny(ref.getObjectId());
            if (!(revObject instanceof RevCommit) || (revCommit2 = (RevCommit)revObject).getCommitTime() + 86400 < revCommit.getCommitTime()) continue;
            arrayList.add(ref);
        }
        List list = revWalk.getMergedInto(revCommit, arrayList, progressMonitor);
        progressMonitor.endTask();
        return list;
    }
}

