/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.LargeObjectException;
import org.eclipse.jgit.errors.RevWalkException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.AsyncObjectLoaderQueue;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdOwnerMap;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.AbstractRevQueue;
import org.eclipse.jgit.revwalk.AsyncRevObjectQueue;
import org.eclipse.jgit.revwalk.DateRevQueue;
import org.eclipse.jgit.revwalk.FIFORevQueue;
import org.eclipse.jgit.revwalk.Generator;
import org.eclipse.jgit.revwalk.ObjectWalk;
import org.eclipse.jgit.revwalk.ReachabilityChecker;
import org.eclipse.jgit.revwalk.RevBlob;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevFlagSet;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk$1;
import org.eclipse.jgit.revwalk.RevWalk$2;
import org.eclipse.jgit.revwalk.RevWalk$3;
import org.eclipse.jgit.revwalk.RevWalk$GetMergedIntoStrategy;
import org.eclipse.jgit.revwalk.StartGenerator;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.References;

public class RevWalk
implements AutoCloseable,
Iterable {
    private static final int MB = 0x100000;
    static final int PARSED = 1;
    static final int SEEN = 2;
    static final int UNINTERESTING = 4;
    static final int REWRITE = 8;
    static final int TEMP_MARK = 16;
    static final int TOPO_DELAY = 32;
    static final int TOPO_QUEUED = 64;
    static final int RESERVED_FLAGS = 7;
    private static final int APP_FLAGS = -128;
    final ObjectReader reader;
    private final boolean closeReader;
    final MutableObjectId idBuffer;
    ObjectIdOwnerMap objects;
    int freeFlags = -128;
    private int delayFreeFlags;
    private int retainOnReset;
    int carryFlags = 4;
    final ArrayList roots;
    AbstractRevQueue queue;
    Generator pending;
    private final EnumSet sorting;
    private RevFilter filter;
    private TreeFilter treeFilter;
    private boolean retainBody = true;
    private boolean rewriteParents = true;
    private boolean firstParent;
    boolean shallowCommitsInitialized;

    public RevWalk(Repository repository) {
        this(repository.newObjectReader(), true);
    }

    public RevWalk(ObjectReader objectReader) {
        this(objectReader, false);
    }

    private RevWalk(ObjectReader objectReader, boolean bl2) {
        this.reader = objectReader;
        this.idBuffer = new MutableObjectId();
        this.objects = new ObjectIdOwnerMap();
        this.roots = new ArrayList();
        this.queue = new DateRevQueue(false);
        this.pending = new StartGenerator(this);
        this.sorting = EnumSet.of(RevSort.NONE);
        this.filter = RevFilter.ALL;
        this.treeFilter = TreeFilter.ALL;
        this.closeReader = bl2;
    }

    public ObjectReader getObjectReader() {
        return this.reader;
    }

    @Deprecated
    public final ReachabilityChecker createReachabilityChecker() {
        return this.reader.createReachabilityChecker(this);
    }

    @Override
    public void close() {
        if (this.closeReader) {
            this.reader.close();
        }
    }

    public void markStart(RevCommit revCommit) {
        if ((revCommit.flags & 2) != 0) {
            return;
        }
        if ((revCommit.flags & 1) == 0) {
            revCommit.parseHeaders(this);
        }
        revCommit.flags |= 2;
        this.roots.add(revCommit);
        this.queue.add(revCommit);
    }

    public void markStart(Collection collection) {
        for (RevCommit revCommit : collection) {
            this.markStart(revCommit);
        }
    }

    public void markUninteresting(RevCommit revCommit) {
        revCommit.flags |= 4;
        this.carryFlagsImpl(revCommit);
        this.markStart(revCommit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMergedInto(RevCommit revCommit, RevCommit revCommit2) {
        RevFilter revFilter = this.filter;
        TreeFilter treeFilter = this.treeFilter;
        try {
            RevCommit revCommit3;
            this.finishDelayedFreeFlags();
            this.reset(~this.freeFlags & 0xFFFFFF80);
            this.filter = RevFilter.MERGE_BASE;
            this.treeFilter = TreeFilter.ALL;
            this.markStart(revCommit2);
            this.markStart(revCommit);
            while ((revCommit3 = this.next()) != null) {
                if (!References.isSameObject(revCommit3, revCommit)) continue;
                boolean bl2 = true;
                return bl2;
            }
            boolean bl3 = false;
            return bl3;
        }
        finally {
            this.filter = revFilter;
            this.treeFilter = treeFilter;
        }
    }

    public List getMergedInto(RevCommit revCommit, Collection collection) {
        return this.getMergedInto(revCommit, collection, NullProgressMonitor.INSTANCE);
    }

    public List getMergedInto(RevCommit revCommit, Collection collection, ProgressMonitor progressMonitor) {
        return this.getMergedInto(revCommit, collection, RevWalk$GetMergedIntoStrategy.EVALUATE_ALL, progressMonitor);
    }

    public boolean isMergedIntoAny(RevCommit revCommit, Collection collection) {
        return this.getMergedInto(revCommit, collection, RevWalk$GetMergedIntoStrategy.RETURN_ON_FIRST_FOUND, NullProgressMonitor.INSTANCE).size() > 0;
    }

    public boolean isMergedIntoAll(RevCommit revCommit, Collection collection) {
        return this.getMergedInto(revCommit, collection, RevWalk$GetMergedIntoStrategy.RETURN_ON_FIRST_NOT_FOUND, NullProgressMonitor.INSTANCE).size() == collection.size();
    }

    /*
     * Exception decompiling
     */
    private List getMergedInto(RevCommit var1_1, Collection var2_2, Enum var3_3, ProgressMonitor var4_4) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 5[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public RevCommit next() {
        return this.pending.next();
    }

    public EnumSet getRevSort() {
        return this.sorting.clone();
    }

    public boolean hasRevSort(RevSort revSort) {
        return this.sorting.contains((Object)revSort);
    }

    public void sort(RevSort revSort) {
        this.assertNotStarted();
        this.sorting.clear();
        this.sorting.add(revSort);
    }

    public void sort(RevSort revSort, boolean bl2) {
        this.assertNotStarted();
        if (bl2) {
            this.sorting.add(revSort);
        } else {
            this.sorting.remove((Object)revSort);
        }
        if (this.sorting.size() > 1) {
            this.sorting.remove((Object)RevSort.NONE);
        } else if (this.sorting.isEmpty()) {
            this.sorting.add(RevSort.NONE);
        }
    }

    @NonNull
    public RevFilter getRevFilter() {
        return this.filter;
    }

    public void setRevFilter(RevFilter revFilter) {
        this.assertNotStarted();
        this.filter = revFilter != null ? revFilter : RevFilter.ALL;
    }

    @NonNull
    public TreeFilter getTreeFilter() {
        return this.treeFilter;
    }

    public void setTreeFilter(TreeFilter treeFilter) {
        this.assertNotStarted();
        this.treeFilter = treeFilter != null ? treeFilter : TreeFilter.ALL;
    }

    public void setRewriteParents(boolean bl2) {
        this.rewriteParents = bl2;
    }

    boolean getRewriteParents() {
        return this.rewriteParents;
    }

    public boolean isRetainBody() {
        return this.retainBody;
    }

    public void setRetainBody(boolean bl2) {
        this.retainBody = bl2;
    }

    public boolean isFirstParent() {
        return this.firstParent;
    }

    public void setFirstParent(boolean bl2) {
        this.assertNotStarted();
        this.assertNoCommitsMarkedStart();
        this.firstParent = bl2;
        this.queue = new DateRevQueue(this.firstParent);
        this.pending = new StartGenerator(this);
    }

    @NonNull
    public RevBlob lookupBlob(AnyObjectId anyObjectId) {
        RevBlob revBlob = (RevBlob)this.objects.get(anyObjectId);
        if (revBlob == null) {
            revBlob = new RevBlob(anyObjectId);
            this.objects.add(revBlob);
        }
        return revBlob;
    }

    @NonNull
    public RevTree lookupTree(AnyObjectId anyObjectId) {
        RevTree revTree = (RevTree)this.objects.get(anyObjectId);
        if (revTree == null) {
            revTree = new RevTree(anyObjectId);
            this.objects.add(revTree);
        }
        return revTree;
    }

    @NonNull
    public RevCommit lookupCommit(AnyObjectId anyObjectId) {
        RevCommit revCommit = (RevCommit)this.objects.get(anyObjectId);
        if (revCommit == null) {
            revCommit = this.createCommit(anyObjectId);
            this.objects.add(revCommit);
        }
        return revCommit;
    }

    @NonNull
    public RevTag lookupTag(AnyObjectId anyObjectId) {
        RevTag revTag = (RevTag)this.objects.get(anyObjectId);
        if (revTag == null) {
            revTag = new RevTag(anyObjectId);
            this.objects.add(revTag);
        }
        return revTag;
    }

    @NonNull
    public RevObject lookupAny(AnyObjectId anyObjectId, int n2) {
        RevObject revObject = (RevObject)this.objects.get(anyObjectId);
        if (revObject == null) {
            switch (n2) {
                case 1: {
                    revObject = this.createCommit(anyObjectId);
                    break;
                }
                case 2: {
                    revObject = new RevTree(anyObjectId);
                    break;
                }
                case 3: {
                    revObject = new RevBlob(anyObjectId);
                    break;
                }
                case 4: {
                    revObject = new RevTag(anyObjectId);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidGitType, n2));
                }
            }
            this.objects.add(revObject);
        }
        return revObject;
    }

    public RevObject lookupOrNull(AnyObjectId anyObjectId) {
        return (RevObject)this.objects.get(anyObjectId);
    }

    @NonNull
    public RevCommit parseCommit(AnyObjectId anyObjectId) {
        RevObject revObject = this.peel(this.parseAny(anyObjectId));
        if (!(revObject instanceof RevCommit)) {
            throw new IncorrectObjectTypeException(anyObjectId.toObjectId(), "commit");
        }
        return (RevCommit)revObject;
    }

    @NonNull
    public RevTree parseTree(AnyObjectId anyObjectId) {
        RevTree revTree;
        RevObject revObject = this.peel(this.parseAny(anyObjectId));
        if (revObject instanceof RevCommit) {
            revTree = ((RevCommit)revObject).getTree();
        } else {
            if (!(revObject instanceof RevTree)) {
                throw new IncorrectObjectTypeException(anyObjectId.toObjectId(), "tree");
            }
            revTree = (RevTree)revObject;
        }
        this.parseHeaders(revTree);
        return revTree;
    }

    @NonNull
    public RevTag parseTag(AnyObjectId anyObjectId) {
        RevObject revObject = this.parseAny(anyObjectId);
        if (!(revObject instanceof RevTag)) {
            throw new IncorrectObjectTypeException(anyObjectId.toObjectId(), "tag");
        }
        return (RevTag)revObject;
    }

    @NonNull
    public RevObject parseAny(AnyObjectId anyObjectId) {
        RevObject revObject = (RevObject)this.objects.get(anyObjectId);
        if (revObject == null) {
            revObject = this.parseNew(anyObjectId, this.reader.open(anyObjectId));
        } else {
            this.parseHeaders(revObject);
        }
        return revObject;
    }

    private RevObject parseNew(AnyObjectId anyObjectId, ObjectLoader objectLoader) {
        RevObject revObject;
        int n2 = objectLoader.getType();
        switch (n2) {
            case 1: {
                RevCommit revCommit = this.createCommit(anyObjectId);
                revCommit.parseCanonical(this, this.getCachedBytes(revCommit, objectLoader));
                revObject = revCommit;
                break;
            }
            case 2: {
                revObject = new RevTree(anyObjectId);
                revObject.flags |= 1;
                break;
            }
            case 3: {
                revObject = new RevBlob(anyObjectId);
                revObject.flags |= 1;
                break;
            }
            case 4: {
                RevTag revTag = new RevTag(anyObjectId);
                revTag.parseCanonical(this, this.getCachedBytes(revTag, objectLoader));
                revObject = revTag;
                break;
            }
            default: {
                throw new IllegalArgumentException(MessageFormat.format(JGitText.get().badObjectType, n2));
            }
        }
        this.objects.add(revObject);
        return revObject;
    }

    byte[] getCachedBytes(RevObject revObject) {
        return this.getCachedBytes(revObject, this.reader.open(revObject, revObject.getType()));
    }

    byte[] getCachedBytes(RevObject revObject, ObjectLoader objectLoader) {
        try {
            return objectLoader.getCachedBytes();
        }
        catch (LargeObjectException largeObjectException) {
            largeObjectException.setObjectId(revObject);
            throw new IOException("A large object could not be read into memory.", largeObjectException);
        }
    }

    public AsyncRevObjectQueue parseAny(Iterable iterable, boolean bl2) {
        Object object2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<RevObject> arrayList2 = new ArrayList<RevObject>();
        for (Object object2 : iterable) {
            RevObject revObject = (RevObject)this.objects.get((AnyObjectId)object2);
            if (revObject != null && (revObject.flags & 1) != 0) {
                arrayList2.add(revObject);
                continue;
            }
            arrayList.add(object2);
        }
        Iterator<Object> iterator = arrayList2.iterator();
        if (arrayList.isEmpty()) {
            return new RevWalk$1(this, iterator);
        }
        object2 = this.reader.open(arrayList, bl2);
        return new RevWalk$2(this, iterator, (AsyncObjectLoaderQueue)object2);
    }

    public void parseHeaders(RevObject revObject) {
        if ((revObject.flags & 1) == 0) {
            revObject.parseHeaders(this);
        }
    }

    public void parseBody(RevObject revObject) {
        revObject.parseBody(this);
    }

    public RevObject peel(RevObject revObject) {
        while (revObject instanceof RevTag) {
            this.parseHeaders(revObject);
            revObject = ((RevTag)revObject).getObject();
        }
        this.parseHeaders(revObject);
        return revObject;
    }

    public RevFlag newFlag(String string) {
        int n2 = this.allocFlag();
        return new RevFlag(this, string, n2);
    }

    int allocFlag() {
        if (this.freeFlags == 0) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().flagsAlreadyCreated, 25));
        }
        int n2 = Integer.lowestOneBit(this.freeFlags);
        this.freeFlags &= ~n2;
        return n2;
    }

    public void carry(RevFlag revFlag) {
        if ((this.freeFlags & revFlag.mask) != 0) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().flagIsDisposed, revFlag.name));
        }
        if (revFlag.walker != this) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().flagNotFromThis, revFlag.name));
        }
        this.carryFlags |= revFlag.mask;
    }

    public void carry(Collection collection) {
        for (RevFlag revFlag : collection) {
            this.carry(revFlag);
        }
    }

    public final void retainOnReset(RevFlag revFlag) {
        if ((this.freeFlags & revFlag.mask) != 0) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().flagIsDisposed, revFlag.name));
        }
        if (revFlag.walker != this) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().flagNotFromThis, revFlag.name));
        }
        this.retainOnReset |= revFlag.mask;
    }

    public final void retainOnReset(Collection collection) {
        for (RevFlag revFlag : collection) {
            this.retainOnReset(revFlag);
        }
    }

    public void disposeFlag(RevFlag revFlag) {
        this.freeFlag(revFlag.mask);
    }

    void freeFlag(int n2) {
        this.retainOnReset &= ~n2;
        if (this.isNotStarted()) {
            this.freeFlags |= n2;
            this.carryFlags &= ~n2;
        } else {
            this.delayFreeFlags |= n2;
        }
    }

    private void finishDelayedFreeFlags() {
        if (this.delayFreeFlags != 0) {
            this.freeFlags |= this.delayFreeFlags;
            this.carryFlags &= ~this.delayFreeFlags;
            this.delayFreeFlags = 0;
        }
    }

    public final void reset() {
        this.reset(0);
    }

    public final void resetRetain(RevFlagSet revFlagSet) {
        this.reset(revFlagSet.mask);
    }

    public final void resetRetain(RevFlag ... revFlagArray) {
        int n2 = 0;
        for (RevFlag revFlag : revFlagArray) {
            n2 |= revFlag.mask;
        }
        this.reset(n2);
    }

    protected void reset(int n2) {
        this.finishDelayedFreeFlags();
        int n3 = ~(n2 |= 1 | this.retainOnReset);
        FIFORevQueue fIFORevQueue = new FIFORevQueue();
        Object object = this.roots.iterator();
        while (object.hasNext()) {
            RevCommit[] revCommitArray = (RevCommit[])object.next();
            if ((revCommitArray.flags & n3) == 0) continue;
            revCommitArray.flags &= n2;
            revCommitArray.reset();
            fIFORevQueue.add((RevCommit)revCommitArray);
        }
        while ((object = fIFORevQueue.next()) != null) {
            if (((RevCommit)object).parents == null) continue;
            for (RevCommit revCommit : ((RevCommit)object).parents) {
                if ((revCommit.flags & n3) == 0) continue;
                revCommit.flags &= n2;
                revCommit.reset();
                fIFORevQueue.add(revCommit);
            }
        }
        this.roots.clear();
        this.queue = new DateRevQueue(this.firstParent);
        this.pending = new StartGenerator(this);
    }

    public void dispose() {
        this.reader.close();
        this.freeFlags = -128;
        this.delayFreeFlags = 0;
        this.retainOnReset = 0;
        this.carryFlags = 4;
        this.firstParent = false;
        this.objects.clear();
        this.roots.clear();
        this.queue = new DateRevQueue(this.firstParent);
        this.pending = new StartGenerator(this);
        this.shallowCommitsInitialized = false;
    }

    @Nullable
    private RevCommit nextForIterator() {
        try {
            return this.next();
        }
        catch (IOException iOException) {
            throw new RevWalkException(iOException);
        }
    }

    public Iterator iterator() {
        RevCommit revCommit = this.nextForIterator();
        return new RevWalk$3(this, revCommit);
    }

    protected void assertNotStarted() {
        if (this.isNotStarted()) {
            return;
        }
        throw new IllegalStateException(JGitText.get().outputHasAlreadyBeenStarted);
    }

    protected void assertNoCommitsMarkedStart() {
        if (this.roots.isEmpty()) {
            return;
        }
        throw new IllegalStateException(JGitText.get().commitsHaveAlreadyBeenMarkedAsStart);
    }

    private boolean isNotStarted() {
        return this.pending instanceof StartGenerator;
    }

    public ObjectWalk toObjectWalkWithSameObjects() {
        ObjectWalk objectWalk;
        ObjectWalk objectWalk2 = objectWalk = new ObjectWalk(this.reader);
        objectWalk2.objects = this.objects;
        objectWalk2.freeFlags = this.freeFlags;
        return objectWalk;
    }

    protected RevCommit createCommit(AnyObjectId anyObjectId) {
        return new RevCommit(anyObjectId);
    }

    void carryFlagsImpl(RevCommit revCommit) {
        int n2 = revCommit.flags & this.carryFlags;
        if (n2 != 0) {
            RevCommit.carryFlags(revCommit, n2);
        }
    }

    public void assumeShallow(Collection collection) {
        for (ObjectId objectId : collection) {
            this.lookupCommit((AnyObjectId)objectId).parents = RevCommit.NO_PARENTS;
        }
    }

    public int size() {
        return this.objects.size();
    }

    public void initializeShallowCommits(RevCommit revCommit) {
        if (this.shallowCommitsInitialized) {
            throw new IllegalStateException(JGitText.get().shallowCommitsAlreadyInitialized);
        }
        this.shallowCommitsInitialized = true;
        if (this.reader == null) {
            return;
        }
        for (ObjectId objectId : this.reader.getShallowCommits()) {
            if (objectId.equals(revCommit.getId())) {
                revCommit.parents = RevCommit.NO_PARENTS;
                continue;
            }
            this.lookupCommit((AnyObjectId)objectId).parents = RevCommit.NO_PARENTS;
        }
    }

    static /* synthetic */ RevObject access$000(RevWalk revWalk, AnyObjectId anyObjectId, ObjectLoader objectLoader) {
        return revWalk.parseNew(anyObjectId, objectLoader);
    }

    static /* synthetic */ RevCommit access$100(RevWalk revWalk) {
        return revWalk.nextForIterator();
    }
}

