/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectInserter$Formatter;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.util.MutableInteger;
import org.eclipse.jgit.util.RawParseUtils;
import org.eclipse.jgit.util.StringUtils;

public class RevTag
extends RevObject {
    private static final byte[] hSignature = Constants.encodeASCII("-----BEGIN PGP SIGNATURE-----");
    private RevObject object;
    private byte[] buffer;
    private String tagName;

    public static RevTag parse(byte[] byArray) {
        return RevTag.parse(new RevWalk((ObjectReader)null), byArray);
    }

    public static RevTag parse(RevWalk revWalk, byte[] byArray) {
        try (ObjectInserter$Formatter objectInserter$Formatter = new ObjectInserter$Formatter();){
            RevTag revTag = revWalk.lookupTag(objectInserter$Formatter.idFor(4, byArray));
            revTag.parseCanonical(revWalk, byArray);
            revTag.buffer = byArray;
            RevTag revTag2 = revTag;
            return revTag2;
        }
    }

    protected RevTag(AnyObjectId anyObjectId) {
        super(anyObjectId);
    }

    @Override
    void parseHeaders(RevWalk revWalk) {
        this.parseCanonical(revWalk, revWalk.getCachedBytes(this));
    }

    @Override
    void parseBody(RevWalk revWalk) {
        if (this.buffer == null) {
            this.buffer = revWalk.getCachedBytes(this);
            if ((this.flags & 1) == 0) {
                this.parseCanonical(revWalk, this.buffer);
            }
        }
    }

    void parseCanonical(RevWalk revWalk, byte[] byArray) {
        MutableInteger mutableInteger = new MutableInteger();
        mutableInteger.value = 53;
        int n2 = Constants.decodeTypeString(this, byArray, (byte)10, mutableInteger);
        revWalk.idBuffer.fromString(byArray, 7);
        this.object = revWalk.lookupAny(revWalk.idBuffer, n2);
        int n3 = mutableInteger.value += 4;
        int n4 = RawParseUtils.nextLF(byArray, n3) - 1;
        this.tagName = RawParseUtils.decode(StandardCharsets.UTF_8, byArray, n3, n4);
        if (revWalk.isRetainBody()) {
            this.buffer = byArray;
        }
        this.flags |= 1;
    }

    @Override
    public final int getType() {
        return 4;
    }

    public final PersonIdent getTaggerIdent() {
        byte[] byArray = this.buffer;
        int n2 = RawParseUtils.tagger(byArray, 0);
        if (n2 < 0) {
            return null;
        }
        return RawParseUtils.parsePersonIdent(byArray, n2);
    }

    private static int nextStart(byte[] byArray, byte[] byArray2, int n2) {
        int n3 = byArray2.length - byArray.length + 1;
        int n4 = n2;
        if (n4 > 0) {
            n4 = RawParseUtils.nextLF(byArray2, n4 - 1);
        }
        while (n4 < n3) {
            int n5 = n4;
            boolean bl2 = true;
            for (byte by : byArray) {
                if (by == byArray2[n4++]) continue;
                bl2 = false;
                break;
            }
            if (bl2) {
                return n5;
            }
            while ((n4 = RawParseUtils.nextLF(byArray2, n4)) < n3 && byArray2[n4] == 10) {
            }
        }
        return -1;
    }

    private int getSignatureStart() {
        int n2;
        byte[] byArray = this.buffer;
        int n3 = RawParseUtils.tagMessage(byArray, 0);
        if (n3 < 0) {
            return n3;
        }
        int n4 = RevTag.nextStart(hSignature, byArray, n3);
        if (n4 < 0) {
            return n4;
        }
        int n5 = RawParseUtils.nextLF(byArray, n4);
        while (n5 < byArray.length && (n2 = RevTag.nextStart(hSignature, byArray, n5)) >= 0) {
            n4 = n2;
            n5 = RawParseUtils.nextLF(byArray, n4);
        }
        return n4;
    }

    @Nullable
    public final byte[] getRawGpgSignature() {
        byte[] byArray = this.buffer;
        int n2 = this.getSignatureStart();
        if (n2 < 0) {
            return null;
        }
        return Arrays.copyOfRange(byArray, n2, byArray.length);
    }

    public final String getFullMessage() {
        int n2;
        byte[] byArray = this.buffer;
        int n3 = RawParseUtils.tagMessage(byArray, 0);
        if (n3 < 0) {
            return "";
        }
        int n4 = this.getSignatureStart();
        int n5 = n2 = n4 < 0 ? byArray.length : n4;
        if (n2 == n3) {
            return "";
        }
        return RawParseUtils.decode(this.guessEncoding(), byArray, n3, n2);
    }

    public final String getShortMessage() {
        byte[] byArray = this.buffer;
        int n2 = RawParseUtils.tagMessage(byArray, 0);
        if (n2 < 0) {
            return "";
        }
        int n3 = RawParseUtils.endOfParagraph(byArray, n2);
        int n4 = this.getSignatureStart();
        if (n4 >= n2 && n3 > n4) {
            n3 = n4;
            if (n3 > n2) {
                --n3;
            }
            if (n2 == n3) {
                return "";
            }
        }
        String string = RawParseUtils.decode(this.guessEncoding(), byArray, n2, n3);
        if (RevCommit.hasLF(byArray, n2, n3)) {
            string = StringUtils.replaceLineBreaksWithSpace(string);
        }
        return string;
    }

    private Charset guessEncoding() {
        try {
            return RawParseUtils.parseEncoding(this.buffer);
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException illegalArgumentException) {
            return StandardCharsets.UTF_8;
        }
    }

    public final RevObject getObject() {
        return this.object;
    }

    public final String getTagName() {
        return this.tagName;
    }

    public final byte[] getRawBuffer() {
        return this.buffer;
    }

    public final void disposeBody() {
        this.buffer = null;
    }
}

