/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.text.MessageFormat;
import java.util.AbstractList;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevObjectList$Block;

public class RevObjectList
extends AbstractList {
    static final int BLOCK_SHIFT = 8;
    static final int BLOCK_SIZE = 256;
    protected RevObjectList$Block contents = new RevObjectList$Block(0);
    protected int size = 0;

    @Override
    public void add(int n2, RevObject revObject) {
        if (n2 != this.size) {
            throw new UnsupportedOperationException(MessageFormat.format(JGitText.get().unsupportedOperationNotAddAtEnd, n2));
        }
        this.set(n2, revObject);
        ++this.size;
    }

    @Override
    public RevObject set(int n2, RevObject revObject) {
        RevObjectList$Block revObjectList$Block = this.contents;
        while (n2 >> revObjectList$Block.shift >= 256) {
            revObjectList$Block = new RevObjectList$Block(revObjectList$Block.shift + 8);
            revObjectList$Block.contents[0] = this.contents;
            this.contents = revObjectList$Block;
        }
        while (revObjectList$Block.shift > 0) {
            int n3 = n2 >> revObjectList$Block.shift;
            n2 -= n3 << revObjectList$Block.shift;
            if (revObjectList$Block.contents[n3] == null) {
                revObjectList$Block.contents[n3] = new RevObjectList$Block(revObjectList$Block.shift - 8);
            }
            revObjectList$Block = (RevObjectList$Block)revObjectList$Block.contents[n3];
        }
        Object object = revObjectList$Block.contents[n2];
        revObjectList$Block.contents[n2] = revObject;
        return (RevObject)object;
    }

    @Override
    public RevObject get(int n2) {
        RevObjectList$Block revObjectList$Block = this.contents;
        if (n2 >> revObjectList$Block.shift >= 1024) {
            return null;
        }
        while (revObjectList$Block != null && revObjectList$Block.shift > 0) {
            int n3 = n2 >> revObjectList$Block.shift;
            n2 -= n3 << revObjectList$Block.shift;
            revObjectList$Block = (RevObjectList$Block)revObjectList$Block.contents[n3];
        }
        return revObjectList$Block != null ? (RevObject)revObjectList$Block.contents[n2] : null;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.contents = new RevObjectList$Block(0);
        this.size = 0;
    }
}

