/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdOwnerMap$Entry;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevFlagSet;
import org.eclipse.jgit.revwalk.RevWalk;

public abstract class RevObject
extends ObjectIdOwnerMap$Entry {
    static final int PARSED = 1;
    int flags;

    RevObject(AnyObjectId anyObjectId) {
        super(anyObjectId);
    }

    abstract void parseHeaders(RevWalk var1);

    abstract void parseBody(RevWalk var1);

    public abstract int getType();

    public final ObjectId getId() {
        return this;
    }

    public final boolean has(RevFlag revFlag) {
        return (this.flags & revFlag.mask) != 0;
    }

    public final boolean hasAny(RevFlagSet revFlagSet) {
        return (this.flags & revFlagSet.mask) != 0;
    }

    public final boolean hasAll(RevFlagSet revFlagSet) {
        return (this.flags & revFlagSet.mask) == revFlagSet.mask;
    }

    public final void add(RevFlag revFlag) {
        this.flags |= revFlag.mask;
    }

    public final void add(RevFlagSet revFlagSet) {
        this.flags |= revFlagSet.mask;
    }

    public final void remove(RevFlag revFlag) {
        this.flags &= ~revFlag.mask;
    }

    public final void remove(RevFlagSet revFlagSet) {
        this.flags &= ~revFlagSet.mask;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Constants.typeString(this.getType()));
        stringBuilder.append(' ');
        stringBuilder.append(this.name());
        stringBuilder.append(' ');
        this.appendCoreFlags(stringBuilder);
        return stringBuilder.toString();
    }

    protected void appendCoreFlags(StringBuilder stringBuilder) {
        stringBuilder.append((this.flags & 0x20) != 0 ? (char)'o' : '-');
        stringBuilder.append((this.flags & 0x40) != 0 ? (char)'q' : '-');
        stringBuilder.append((this.flags & 0x10) != 0 ? (char)'t' : '-');
        stringBuilder.append((this.flags & 8) != 0 ? (char)'r' : '-');
        stringBuilder.append((this.flags & 4) != 0 ? (char)'u' : '-');
        stringBuilder.append((this.flags & 2) != 0 ? (char)'s' : '-');
        stringBuilder.append((this.flags & 1) != 0 ? (char)'p' : '-');
    }
}

