/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevFlagSet$1;

public class RevFlagSet
extends AbstractSet {
    int mask;
    private final List active;

    public RevFlagSet() {
        this.active = new ArrayList();
    }

    public RevFlagSet(RevFlagSet revFlagSet) {
        this.mask = revFlagSet.mask;
        this.active = new ArrayList(revFlagSet.active);
    }

    public RevFlagSet(Collection collection) {
        this();
        this.addAll(collection);
    }

    @Override
    public boolean contains(Object object) {
        if (object instanceof RevFlag) {
            return (this.mask & ((RevFlag)object).mask) != 0;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection collection) {
        if (collection instanceof RevFlagSet) {
            int n2 = ((RevFlagSet)collection).mask;
            return (this.mask & n2) == n2;
        }
        return super.containsAll(collection);
    }

    @Override
    public boolean add(RevFlag revFlag) {
        int n2;
        if ((this.mask & revFlag.mask) != 0) {
            return false;
        }
        this.mask |= revFlag.mask;
        for (n2 = 0; n2 < this.active.size() && ((RevFlag)this.active.get((int)n2)).mask < revFlag.mask; ++n2) {
        }
        this.active.add(n2, revFlag);
        return true;
    }

    @Override
    public boolean remove(Object object) {
        RevFlag revFlag = (RevFlag)object;
        if ((this.mask & revFlag.mask) == 0) {
            return false;
        }
        this.mask &= ~revFlag.mask;
        for (int i2 = 0; i2 < this.active.size(); ++i2) {
            if (((RevFlag)this.active.get((int)i2)).mask != revFlag.mask) continue;
            this.active.remove(i2);
        }
        return true;
    }

    @Override
    public Iterator iterator() {
        Iterator iterator = this.active.iterator();
        return new RevFlagSet$1(this, iterator);
    }

    @Override
    public int size() {
        return this.active.size();
    }
}

