/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.io.IOException;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevObjectList;
import org.eclipse.jgit.revwalk.RevObjectList$Block;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;

public class RevCommitList
extends RevObjectList {
    private RevWalk walker;

    @Override
    public void clear() {
        super.clear();
        this.walker = null;
    }

    public void applyFlag(RevFilter revFilter, RevFlag revFlag) {
        this.applyFlag(revFilter, revFlag, 0, this.size());
    }

    public void applyFlag(RevFilter revFilter, RevFlag revFlag, int n2, int n3) {
        RevWalk revWalk = revFlag.getRevWalk();
        n3 = Math.min(n3, this.size());
        while (n2 < n3) {
            int n4 = n2;
            RevObjectList$Block revObjectList$Block = this.contents;
            while (revObjectList$Block.shift > 0) {
                int n5 = n4 >> revObjectList$Block.shift;
                n4 -= n5 << revObjectList$Block.shift;
                revObjectList$Block = (RevObjectList$Block)revObjectList$Block.contents[n5];
            }
            while (n2++ < n3 && n4 < 256) {
                RevCommit revCommit;
                if (revFilter.include(revWalk, revCommit = (RevCommit)revObjectList$Block.contents[n4++])) {
                    revCommit.add(revFlag);
                    continue;
                }
                revCommit.remove(revFlag);
            }
        }
    }

    public void clearFlag(RevFlag revFlag) {
        this.clearFlag(revFlag, 0, this.size());
    }

    public void clearFlag(RevFlag revFlag, int n2, int n3) {
        try {
            this.applyFlag(RevFilter.NONE, revFlag, n2, n3);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int indexOf(RevFlag revFlag, int n2) {
        while (n2 < this.size()) {
            int n3 = n2;
            RevObjectList$Block revObjectList$Block = this.contents;
            while (revObjectList$Block.shift > 0) {
                int n4 = n3 >> revObjectList$Block.shift;
                n3 -= n4 << revObjectList$Block.shift;
                revObjectList$Block = (RevObjectList$Block)revObjectList$Block.contents[n4];
            }
            while (n2++ < this.size() && n3 < 256) {
                RevCommit revCommit;
                if (!(revCommit = (RevCommit)revObjectList$Block.contents[n3++]).has(revFlag)) continue;
                return n2;
            }
        }
        return -1;
    }

    public int lastIndexOf(RevFlag revFlag, int n2) {
        n2 = Math.min(n2, this.size() - 1);
        while (n2 >= 0) {
            int n3 = n2;
            RevObjectList$Block revObjectList$Block = this.contents;
            while (revObjectList$Block.shift > 0) {
                int n4 = n3 >> revObjectList$Block.shift;
                n3 -= n4 << revObjectList$Block.shift;
                revObjectList$Block = (RevObjectList$Block)revObjectList$Block.contents[n4];
            }
            while (n2-- >= 0 && n3 >= 0) {
                RevCommit revCommit;
                if (!(revCommit = (RevCommit)revObjectList$Block.contents[n3--]).has(revFlag)) continue;
                return n2;
            }
        }
        return -1;
    }

    public void source(RevWalk revWalk) {
        this.walker = revWalk;
    }

    public boolean isPending() {
        return this.walker != null;
    }

    public void fillTo(int n2) {
        if (this.walker == null || this.size > n2) {
            return;
        }
        RevCommit revCommit = this.walker.next();
        if (revCommit == null) {
            this.walker = null;
            return;
        }
        this.enter(this.size, revCommit);
        this.add(revCommit);
        while (this.size <= n2) {
            int n3 = this.size;
            RevObjectList$Block revObjectList$Block = this.contents;
            while (n3 >> revObjectList$Block.shift >= 256) {
                revObjectList$Block = new RevObjectList$Block(revObjectList$Block.shift + 8);
                revObjectList$Block.contents[0] = this.contents;
                this.contents = revObjectList$Block;
            }
            while (revObjectList$Block.shift > 0) {
                int n4 = n3 >> revObjectList$Block.shift;
                n3 -= n4 << revObjectList$Block.shift;
                if (revObjectList$Block.contents[n4] == null) {
                    revObjectList$Block.contents[n4] = new RevObjectList$Block(revObjectList$Block.shift - 8);
                }
                revObjectList$Block = (RevObjectList$Block)revObjectList$Block.contents[n4];
            }
            Object[] objectArray = revObjectList$Block.contents;
            while (this.size <= n2 && n3 < 256) {
                revCommit = this.walker.next();
                if (revCommit == null) {
                    this.walker = null;
                    return;
                }
                this.enter(this.size++, revCommit);
                objectArray[n3++] = revCommit;
            }
        }
    }

    public void fillTo(RevCommit revCommit, int n2) {
        if (this.walker == null || revCommit == null || n2 > 0 && this.size > n2) {
            return;
        }
        RevCommit revCommit2 = this.walker.next();
        if (revCommit2 == null) {
            this.walker = null;
            return;
        }
        this.enter(this.size, revCommit2);
        this.add(revCommit2);
        while (!(n2 != 0 && this.size > n2 || revCommit2.equals(revCommit))) {
            int n3 = this.size;
            RevObjectList$Block revObjectList$Block = this.contents;
            while (n3 >> revObjectList$Block.shift >= 256) {
                revObjectList$Block = new RevObjectList$Block(revObjectList$Block.shift + 8);
                revObjectList$Block.contents[0] = this.contents;
                this.contents = revObjectList$Block;
            }
            while (revObjectList$Block.shift > 0) {
                int n4 = n3 >> revObjectList$Block.shift;
                n3 -= n4 << revObjectList$Block.shift;
                if (revObjectList$Block.contents[n4] == null) {
                    revObjectList$Block.contents[n4] = new RevObjectList$Block(revObjectList$Block.shift - 8);
                }
                revObjectList$Block = (RevObjectList$Block)revObjectList$Block.contents[n4];
            }
            Object[] objectArray = revObjectList$Block.contents;
            while (!(n2 != 0 && this.size > n2 || n3 >= 256 || revCommit2.equals(revCommit))) {
                revCommit2 = this.walker.next();
                if (revCommit2 == null) {
                    this.walker = null;
                    return;
                }
                this.enter(this.size++, revCommit2);
                objectArray[n3++] = revCommit2;
            }
        }
    }

    protected void enter(int n2, RevCommit revCommit) {
    }
}

