/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectInserter$Formatter;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.revwalk.FIFORevQueue;
import org.eclipse.jgit.revwalk.FooterKey;
import org.eclipse.jgit.revwalk.FooterLine;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.util.RawParseUtils;
import org.eclipse.jgit.util.StringUtils;

public class RevCommit
extends RevObject {
    private static final int STACK_DEPTH = 500;
    static final RevCommit[] NO_PARENTS = new RevCommit[0];
    private RevTree tree;
    RevCommit[] parents;
    int commitTime;
    int inDegree;
    private byte[] buffer;

    public static RevCommit parse(byte[] byArray) {
        try {
            return RevCommit.parse(new RevWalk((ObjectReader)null), byArray);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static RevCommit parse(RevWalk revWalk, byte[] byArray) {
        try (ObjectInserter$Formatter objectInserter$Formatter = new ObjectInserter$Formatter();){
            RevCommit revCommit = revWalk.lookupCommit(objectInserter$Formatter.idFor(1, byArray));
            revCommit.parseCanonical(revWalk, byArray);
            revCommit.buffer = byArray;
            RevCommit revCommit2 = revCommit;
            return revCommit2;
        }
    }

    protected RevCommit(AnyObjectId anyObjectId) {
        super(anyObjectId);
    }

    @Override
    void parseHeaders(RevWalk revWalk) {
        this.parseCanonical(revWalk, revWalk.getCachedBytes(this));
    }

    @Override
    void parseBody(RevWalk revWalk) {
        if (this.buffer == null) {
            this.buffer = revWalk.getCachedBytes(this);
            if ((this.flags & 1) == 0) {
                this.parseCanonical(revWalk, this.buffer);
            }
        }
    }

    void parseCanonical(RevWalk revWalk, byte[] byArray) {
        if (!revWalk.shallowCommitsInitialized) {
            revWalk.initializeShallowCommits(this);
        }
        MutableObjectId mutableObjectId = revWalk.idBuffer;
        mutableObjectId.fromString(byArray, 5);
        this.tree = revWalk.lookupTree(mutableObjectId);
        int n2 = 46;
        if (this.parents == null) {
            Object object;
            RevCommit[] revCommitArray = new RevCommit[1];
            int n3 = 0;
            while (byArray[n2] == 112) {
                mutableObjectId.fromString(byArray, n2 + 7);
                object = revWalk.lookupCommit(mutableObjectId);
                switch (n3) {
                    case 0: {
                        revCommitArray[n3++] = object;
                        break;
                    }
                    case 1: {
                        revCommitArray = new RevCommit[]{revCommitArray[0], object};
                        n3 = 2;
                        break;
                    }
                    default: {
                        if (revCommitArray.length <= n3) {
                            RevCommit[] revCommitArray2 = revCommitArray;
                            revCommitArray = new RevCommit[revCommitArray.length + 32];
                            System.arraycopy(revCommitArray2, 0, revCommitArray, 0, n3);
                        }
                        revCommitArray[n3++] = object;
                    }
                }
                n2 += 48;
            }
            if (n3 != revCommitArray.length) {
                object = revCommitArray;
                revCommitArray = new RevCommit[n3];
                System.arraycopy(object, 0, revCommitArray, 0, n3);
            }
            this.parents = revCommitArray;
        }
        if ((n2 = RawParseUtils.committer(byArray, n2)) > 0) {
            n2 = RawParseUtils.nextLF(byArray, n2, '>');
            this.commitTime = RawParseUtils.parseBase10(byArray, n2, null);
        }
        if (revWalk.isRetainBody()) {
            this.buffer = byArray;
        }
        this.flags |= 1;
    }

    @Override
    public final int getType() {
        return 1;
    }

    static void carryFlags(RevCommit revCommit, int n2) {
        FIFORevQueue fIFORevQueue = RevCommit.carryFlags1(revCommit, n2, 0);
        if (fIFORevQueue != null) {
            RevCommit.slowCarryFlags(fIFORevQueue, n2);
        }
    }

    private static FIFORevQueue carryFlags1(RevCommit revCommit, int n2, int n3) {
        RevCommit[] revCommitArray;
        while ((revCommitArray = revCommit.parents) != null && revCommitArray.length != 0) {
            if (revCommitArray.length != 1) {
                if (n3 == 500) {
                    return RevCommit.defer(revCommit);
                }
                for (int i2 = 1; i2 < revCommitArray.length; ++i2) {
                    RevCommit revCommit2 = revCommitArray[i2];
                    if ((revCommit2.flags & n2) == n2) continue;
                    revCommit2.flags |= n2;
                    FIFORevQueue fIFORevQueue = RevCommit.carryFlags1(revCommit2, n2, n3 + 1);
                    if (fIFORevQueue == null) continue;
                    return RevCommit.defer(fIFORevQueue, n2, revCommitArray, i2 + 1);
                }
            }
            revCommit = revCommitArray[0];
            if ((revCommit.flags & n2) == n2) {
                return null;
            }
            revCommit.flags |= n2;
        }
        return null;
    }

    private static FIFORevQueue defer(RevCommit revCommit) {
        FIFORevQueue fIFORevQueue = new FIFORevQueue();
        fIFORevQueue.add(revCommit);
        return fIFORevQueue;
    }

    private static FIFORevQueue defer(FIFORevQueue fIFORevQueue, int n2, RevCommit[] revCommitArray, int n3) {
        RevCommit.carryOneStep(fIFORevQueue, n2, revCommitArray[0]);
        while (n3 < revCommitArray.length) {
            RevCommit.carryOneStep(fIFORevQueue, n2, revCommitArray[n3]);
            ++n3;
        }
        return fIFORevQueue;
    }

    private static void slowCarryFlags(FIFORevQueue fIFORevQueue, int n2) {
        RevCommit revCommit;
        while ((revCommit = fIFORevQueue.next()) != null) {
            for (RevCommit revCommit2 : revCommit.parents) {
                RevCommit.carryOneStep(fIFORevQueue, n2, revCommit2);
            }
        }
    }

    private static void carryOneStep(FIFORevQueue fIFORevQueue, int n2, RevCommit revCommit) {
        if ((revCommit.flags & n2) != n2) {
            revCommit.flags |= n2;
            if (revCommit.parents != null) {
                fIFORevQueue.add(revCommit);
            }
        }
    }

    public void carry(RevFlag revFlag) {
        int n2 = this.flags & revFlag.mask;
        if (n2 != 0) {
            RevCommit.carryFlags(this, n2);
        }
    }

    public final int getCommitTime() {
        return this.commitTime;
    }

    public final RevTree getTree() {
        return this.tree;
    }

    public final int getParentCount() {
        return this.parents.length;
    }

    public final RevCommit getParent(int n2) {
        return this.parents[n2];
    }

    public final RevCommit[] getParents() {
        return this.parents;
    }

    public final byte[] getRawBuffer() {
        return this.buffer;
    }

    public final byte[] getRawGpgSignature() {
        byte[] byArray = this.buffer;
        byte[] byArray2 = new byte[]{103, 112, 103, 115, 105, 103};
        int n2 = RawParseUtils.headerStart(byArray2, byArray, 0);
        if (n2 < 0) {
            return null;
        }
        int n3 = RawParseUtils.headerEnd(byArray, n2);
        return Arrays.copyOfRange(byArray, n2, n3);
    }

    public final PersonIdent getAuthorIdent() {
        byte[] byArray = this.buffer;
        int n2 = RawParseUtils.author(byArray, 0);
        if (n2 < 0) {
            return null;
        }
        return RawParseUtils.parsePersonIdent(byArray, n2);
    }

    public final PersonIdent getCommitterIdent() {
        byte[] byArray = this.buffer;
        int n2 = RawParseUtils.committer(byArray, 0);
        if (n2 < 0) {
            return null;
        }
        return RawParseUtils.parsePersonIdent(byArray, n2);
    }

    public final String getFullMessage() {
        byte[] byArray = this.buffer;
        int n2 = RawParseUtils.commitMessage(byArray, 0);
        if (n2 < 0) {
            return "";
        }
        return RawParseUtils.decode(this.guessEncoding(), byArray, n2, byArray.length);
    }

    public final String getShortMessage() {
        byte[] byArray = this.buffer;
        int n2 = RawParseUtils.commitMessage(byArray, 0);
        if (n2 < 0) {
            return "";
        }
        int n3 = RawParseUtils.endOfParagraph(byArray, n2);
        String string = RawParseUtils.decode(this.guessEncoding(), byArray, n2, n3);
        if (RevCommit.hasLF(byArray, n2, n3)) {
            string = StringUtils.replaceLineBreaksWithSpace(string);
        }
        return string;
    }

    static boolean hasLF(byte[] byArray, int n2, int n3) {
        while (n2 < n3) {
            if (byArray[n2++] != 10) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public final String getEncodingName() {
        return RawParseUtils.parseEncodingName(this.buffer);
    }

    public final Charset getEncoding() {
        return RawParseUtils.parseEncoding(this.buffer);
    }

    private Charset guessEncoding() {
        try {
            return this.getEncoding();
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException illegalArgumentException) {
            return StandardCharsets.UTF_8;
        }
    }

    public final List getFooterLines() {
        int n2;
        byte[] byArray = this.buffer;
        int n3 = byArray.length - 1;
        while (byArray[n3] == 10) {
            --n3;
        }
        int n4 = RawParseUtils.commitMessage(byArray, 0);
        ArrayList<FooterLine> arrayList = new ArrayList<FooterLine>(4);
        Charset charset = this.guessEncoding();
        while ((n3 = RawParseUtils.prevLF(byArray, n3)) > n4 && byArray[n2 = n3 + 2] != 10) {
            int n5;
            int n6 = RawParseUtils.endOfFooterLineKey(byArray, n2);
            if (n6 < 0) continue;
            for (n5 = n6 + 1; n5 < byArray.length && byArray[n5] == 32; ++n5) {
            }
            int n7 = RawParseUtils.nextLF(byArray, n5);
            if (byArray[n7 - 1] == 10) {
                --n7;
            }
            arrayList.add(new FooterLine(byArray, charset, n2, n6, n5, n7));
        }
        Collections.reverse(arrayList);
        return arrayList;
    }

    public final List getFooterLines(String string) {
        return this.getFooterLines(new FooterKey(string));
    }

    public final List getFooterLines(FooterKey footerKey) {
        List list = this.getFooterLines();
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (FooterLine footerLine : list) {
            if (!footerLine.matches(footerKey)) continue;
            arrayList.add(footerLine.getValue());
        }
        return arrayList;
    }

    public void reset() {
        this.inDegree = 0;
    }

    public final void disposeBody() {
        this.buffer = null;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Constants.typeString(this.getType()));
        stringBuilder.append(' ');
        stringBuilder.append(this.name());
        stringBuilder.append(' ');
        stringBuilder.append(this.commitTime);
        stringBuilder.append(' ');
        this.appendCoreFlags(stringBuilder);
        return stringBuilder.toString();
    }
}

