/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import org.eclipse.jgit.errors.StopWalkException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.DateRevQueue;
import org.eclipse.jgit.revwalk.Generator;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;

class PendingGenerator
extends Generator {
    private static final int PARSED = 1;
    private static final int SEEN = 2;
    private static final int UNINTERESTING = 4;
    static final int OVER_SCAN = 6;
    private static final RevCommit INIT_LAST = new RevCommit(ObjectId.zeroId());
    private final RevWalk walker;
    private final DateRevQueue pending;
    private final RevFilter filter;
    private final int output;
    private RevCommit last = INIT_LAST;
    private int overScan = 6;
    boolean canDispose;

    PendingGenerator(RevWalk revWalk, DateRevQueue dateRevQueue, RevFilter revFilter, int n2) {
        super(revWalk.isFirstParent());
        this.walker = revWalk;
        this.pending = dateRevQueue;
        this.filter = revFilter;
        this.output = n2;
        this.canDispose = true;
    }

    @Override
    int outputType() {
        return this.output | 1;
    }

    @Override
    RevCommit next() {
        try {
            while (true) {
                boolean bl2;
                RevCommit revCommit;
                if ((revCommit = this.pending.next()) == null) {
                    return null;
                }
                if ((revCommit.flags & 4) != 0) {
                    bl2 = false;
                } else {
                    if (this.filter.requiresCommitBody()) {
                        revCommit.parseBody(this.walker);
                    }
                    bl2 = this.filter.include(this.walker, revCommit);
                }
                for (int i2 = 0; i2 < revCommit.parents.length; ++i2) {
                    RevCommit revCommit2 = revCommit.parents[i2];
                    if (this.firstParent && i2 > 0 && (revCommit.flags & 4) == 0 || (revCommit2.flags & 2) != 0) continue;
                    if ((revCommit2.flags & 1) == 0) {
                        revCommit2.parseHeaders(this.walker);
                    }
                    revCommit2.flags |= 2;
                    this.pending.add(revCommit2);
                }
                this.walker.carryFlagsImpl(revCommit);
                if ((revCommit.flags & 4) != 0) {
                    if (this.pending.everbodyHasFlag(4)) {
                        RevCommit revCommit3 = this.pending.peek();
                        if (revCommit3 != null && revCommit3.commitTime >= this.last.commitTime) {
                            this.overScan = 6;
                        } else if (--this.overScan == 0) {
                            throw StopWalkException.INSTANCE;
                        }
                    } else {
                        this.overScan = 6;
                    }
                    if (!this.canDispose) continue;
                    revCommit.disposeBody();
                    continue;
                }
                if (bl2) {
                    this.last = revCommit;
                    return this.last;
                }
                if (!this.canDispose) continue;
                revCommit.disposeBody();
            }
        }
        catch (StopWalkException stopWalkException) {
            this.pending.clear();
            return null;
        }
    }

    static {
        PendingGenerator.INIT_LAST.commitTime = Integer.MAX_VALUE;
    }
}

