/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.BlockObjQueue;
import org.eclipse.jgit.revwalk.ObjectReachabilityChecker;
import org.eclipse.jgit.revwalk.ObjectWalk$1;
import org.eclipse.jgit.revwalk.ObjectWalk$TreeVisit;
import org.eclipse.jgit.revwalk.ObjectWalk$VisitationPolicy;
import org.eclipse.jgit.revwalk.RevBlob;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.ObjectFilter;
import org.eclipse.jgit.util.RawParseUtils;

public class ObjectWalk
extends RevWalk {
    private static final int ID_SZ = 20;
    private static final int TYPE_SHIFT = 12;
    private static final int TYPE_TREE = 4;
    private static final int TYPE_SYMLINK = 10;
    private static final int TYPE_FILE = 8;
    private static final int TYPE_GITLINK = 14;
    private static final int IN_PENDING = 8;
    public static final ObjectWalk$VisitationPolicy SIMPLE_VISITATION_POLICY = new ObjectWalk$1();
    private List rootObjects;
    private BlockObjQueue pendingObjects;
    private ObjectFilter objectFilter;
    private ObjectWalk$TreeVisit freeVisit;
    private ObjectWalk$TreeVisit currVisit;
    private byte[] pathBuf;
    private int pathLen;
    private boolean boundary;
    private ObjectWalk$VisitationPolicy visitationPolicy = SIMPLE_VISITATION_POLICY;

    public ObjectWalk(Repository repository) {
        this(repository.newObjectReader());
    }

    public ObjectWalk(ObjectReader objectReader) {
        super(objectReader);
        this.setRetainBody(false);
        this.rootObjects = new ArrayList();
        this.pendingObjects = new BlockObjQueue();
        this.objectFilter = ObjectFilter.ALL;
        this.pathBuf = new byte[256];
    }

    @Deprecated
    public final ObjectReachabilityChecker createObjectReachabilityChecker() {
        return this.reader.createObjectReachabilityChecker(this);
    }

    public void markStart(RevObject revObject) {
        while (revObject instanceof RevTag) {
            this.addObject(revObject);
            revObject = ((RevTag)revObject).getObject();
            this.parseHeaders(revObject);
        }
        if (revObject instanceof RevCommit) {
            super.markStart((RevCommit)revObject);
        } else {
            this.addObject(revObject);
        }
    }

    public void markUninteresting(RevObject revObject) {
        while (revObject instanceof RevTag) {
            revObject.flags |= 4;
            if (this.boundary) {
                this.addObject(revObject);
            }
            revObject = ((RevTag)revObject).getObject();
            this.parseHeaders(revObject);
        }
        if (revObject instanceof RevCommit) {
            super.markUninteresting((RevCommit)revObject);
        } else if (revObject instanceof RevTree) {
            this.markTreeUninteresting((RevTree)revObject);
        } else {
            revObject.flags |= 4;
        }
        if (revObject.getType() != 1 && this.boundary) {
            this.addObject(revObject);
        }
    }

    @Override
    public void sort(RevSort revSort) {
        super.sort(revSort);
        this.boundary = this.hasRevSort(RevSort.BOUNDARY);
    }

    @Override
    public void sort(RevSort revSort, boolean bl2) {
        super.sort(revSort, bl2);
        this.boundary = this.hasRevSort(RevSort.BOUNDARY);
    }

    public ObjectFilter getObjectFilter() {
        return this.objectFilter;
    }

    public void setObjectFilter(ObjectFilter objectFilter) {
        this.assertNotStarted();
        this.objectFilter = objectFilter != null ? objectFilter : ObjectFilter.ALL;
    }

    public void setVisitationPolicy(ObjectWalk$VisitationPolicy visitationPolicy) {
        this.assertNotStarted();
        this.visitationPolicy = Objects.requireNonNull(visitationPolicy);
    }

    @Override
    public RevCommit next() {
        RevTree revTree;
        RevCommit revCommit;
        block3: {
            do {
                if ((revCommit = super.next()) == null) {
                    return null;
                }
                revTree = revCommit.getTree();
                if ((revCommit.flags & 4) == 0) break block3;
                if (!this.objectFilter.include(this, revTree)) continue;
                this.markTreeUninteresting(revTree);
            } while (!this.boundary);
            return revCommit;
        }
        if (this.objectFilter.include(this, revTree)) {
            this.pendingObjects.add(revTree);
        }
        return revCommit;
    }

    public void skipTree() {
        if (this.currVisit != null) {
            this.currVisit.ptr = this.currVisit.buf.length;
        }
    }

    public RevObject nextObject() {
        Object object;
        this.pathLen = 0;
        ObjectWalk$TreeVisit objectWalk$TreeVisit = this.currVisit;
        while (objectWalk$TreeVisit != null) {
            object = objectWalk$TreeVisit.buf;
            block6: for (int i2 = objectWalk$TreeVisit.ptr; i2 < ((byte[])object).length; i2 += 20) {
                RevObject revObject;
                int n2 = i2;
                i2 = ObjectWalk.findObjectId(object, i2);
                this.idBuffer.fromRaw((byte[])object, i2);
                if (!this.objectFilter.include(this, this.idBuffer) || (revObject = (RevObject)this.objects.get(this.idBuffer)) != null && !this.visitationPolicy.shouldVisit(revObject)) continue;
                int n3 = ObjectWalk.parseMode(object, n2, i2, objectWalk$TreeVisit);
                switch (n3 >>> 12) {
                    case 8: 
                    case 10: {
                        if (revObject == null) {
                            revObject = new RevBlob(this.idBuffer);
                            this.visitationPolicy.visited(revObject);
                            this.objects.add(revObject);
                            return revObject;
                        }
                        if (!(revObject instanceof RevBlob)) {
                            throw new IncorrectObjectTypeException((ObjectId)revObject, 3);
                        }
                        this.visitationPolicy.visited(revObject);
                        if ((revObject.flags & 4) != 0) continue block6;
                        return revObject;
                    }
                    case 4: {
                        if (revObject == null) {
                            revObject = new RevTree(this.idBuffer);
                            this.visitationPolicy.visited(revObject);
                            this.objects.add(revObject);
                            return this.pushTree(revObject);
                        }
                        if (!(revObject instanceof RevTree)) {
                            throw new IncorrectObjectTypeException((ObjectId)revObject, 2);
                        }
                        this.visitationPolicy.visited(revObject);
                        if ((revObject.flags & 4) != 0) continue block6;
                        return this.pushTree(revObject);
                    }
                    case 14: {
                        continue block6;
                    }
                }
                throw new CorruptObjectException(MessageFormat.format(JGitText.get().corruptObjectInvalidMode3, String.format("%o", n3), this.idBuffer.name(), RawParseUtils.decode(object, objectWalk$TreeVisit.namePtr, objectWalk$TreeVisit.nameEnd), objectWalk$TreeVisit.obj));
            }
            this.currVisit = objectWalk$TreeVisit.parent;
            this.releaseTreeVisit(objectWalk$TreeVisit);
            objectWalk$TreeVisit = this.currVisit;
        }
        while (true) {
            if ((object = (Object)this.pendingObjects.next()) == null) {
                return null;
            }
            if (!this.visitationPolicy.shouldVisit((RevObject)object)) continue;
            this.visitationPolicy.visited((RevObject)object);
            if ((object.flags & 4) == 0 || this.boundary) break;
        }
        if (object instanceof RevTree) {
            assert (this.currVisit == null);
            this.pushTree((RevObject)object);
        }
        return object;
    }

    private static int findObjectId(byte[] byArray, int n2) {
        do {
            if (byArray[++n2] == 0) {
                return ++n2;
            }
            if (byArray[++n2] == 0) {
                return ++n2;
            }
            if (byArray[++n2] == 0) {
                return ++n2;
            }
            if (byArray[++n2] == 0) {
                return ++n2;
            }
            if (byArray[++n2] == 0) {
                return ++n2;
            }
            if (byArray[++n2] == 0) {
                return ++n2;
            }
            if (byArray[++n2] == 0) {
                return ++n2;
            }
            if (byArray[++n2] == 0) {
                return ++n2;
            }
            if (byArray[++n2] == 0) {
                return ++n2;
            }
            if (byArray[++n2] == 0) {
                return ++n2;
            }
            if (byArray[++n2] == 0) {
                return ++n2;
            }
            if (byArray[++n2] == 0) {
                return ++n2;
            }
            if (byArray[++n2] == 0) {
                return ++n2;
            }
            if (byArray[++n2] == 0) {
                return ++n2;
            }
            if (byArray[++n2] != 0) continue;
            return ++n2;
        } while (byArray[++n2] != 0);
        return ++n2;
    }

    private static int parseMode(byte[] byArray, int n2, int n3, ObjectWalk$TreeVisit objectWalk$TreeVisit) {
        byte by;
        int n4 = byArray[n2] - 48;
        while (32 != (by = byArray[++n2])) {
            n4 <<= 3;
            n4 += by - 48;
            if (32 == (by = byArray[++n2])) break;
            n4 <<= 3;
            n4 += by - 48;
            if (32 == (by = byArray[++n2])) break;
            n4 <<= 3;
            n4 += by - 48;
            if (32 == (by = byArray[++n2])) break;
            n4 <<= 3;
            n4 += by - 48;
            if (32 == (by = byArray[++n2])) break;
            n4 <<= 3;
            n4 += by - 48;
            if (32 == (by = byArray[++n2])) break;
            n4 <<= 3;
            n4 += by - 48;
            if (32 == (by = byArray[++n2])) break;
            n4 <<= 3;
            n4 += by - 48;
        }
        objectWalk$TreeVisit.ptr = n3;
        objectWalk$TreeVisit.namePtr = n2 + 1;
        objectWalk$TreeVisit.nameEnd = n3 - 21;
        return n4;
    }

    public void checkConnectivity() {
        RevObject revObject;
        while ((revObject = this.next()) != null) {
        }
        while ((revObject = this.nextObject()) != null) {
            if (!(revObject instanceof RevBlob) || this.reader.has(revObject)) continue;
            throw new MissingObjectException((ObjectId)revObject, 3);
        }
    }

    public String getPathString() {
        if (this.pathLen == 0) {
            this.pathLen = this.updatePathBuf(this.currVisit);
            if (this.pathLen == 0) {
                return null;
            }
        }
        return RawParseUtils.decode(this.pathBuf, 0, this.pathLen);
    }

    public int getTreeDepth() {
        if (this.currVisit == null) {
            return 0;
        }
        return this.currVisit.depth;
    }

    public int getPathHashCode() {
        int n2;
        byte[] byArray;
        ObjectWalk$TreeVisit objectWalk$TreeVisit = this.currVisit;
        if (objectWalk$TreeVisit == null) {
            return 0;
        }
        int n3 = objectWalk$TreeVisit.nameEnd;
        if (n3 == 0) {
            objectWalk$TreeVisit = objectWalk$TreeVisit.parent;
            if (objectWalk$TreeVisit == null) {
                return 0;
            }
            n3 = objectWalk$TreeVisit.nameEnd;
        }
        if (16 <= n3 - objectWalk$TreeVisit.namePtr) {
            byArray = objectWalk$TreeVisit.buf;
            n2 = n3 - 16;
        } else {
            n3 = this.pathLen;
            if (n3 == 0) {
                this.pathLen = n3 = this.updatePathBuf(this.currVisit);
            }
            byArray = this.pathBuf;
            n2 = Math.max(0, n3 - 16);
        }
        int n4 = 0;
        while (n2 < n3) {
            byte by = byArray[n2];
            if (by != 32) {
                n4 = (n4 >>> 2) + (by << 24);
            }
            ++n2;
        }
        return n4;
    }

    public byte[] getPathBuffer() {
        if (this.pathLen == 0) {
            this.pathLen = this.updatePathBuf(this.currVisit);
        }
        return this.pathBuf;
    }

    public int getPathLength() {
        if (this.pathLen == 0) {
            this.pathLen = this.updatePathBuf(this.currVisit);
        }
        return this.pathLen;
    }

    private int updatePathBuf(ObjectWalk$TreeVisit objectWalk$TreeVisit) {
        if (objectWalk$TreeVisit == null) {
            return 0;
        }
        int n2 = objectWalk$TreeVisit.nameEnd;
        if (n2 == 0) {
            return this.updatePathBuf(objectWalk$TreeVisit.parent);
        }
        int n3 = objectWalk$TreeVisit.pathLen;
        if (n3 == 0) {
            n3 = this.updatePathBuf(objectWalk$TreeVisit.parent);
            if (n3 == this.pathBuf.length) {
                this.growPathBuf(n3);
            }
            if (n3 != 0) {
                this.pathBuf[n3++] = 47;
            }
            objectWalk$TreeVisit.pathLen = n3;
        }
        int n4 = objectWalk$TreeVisit.namePtr;
        int n5 = n2 - n4;
        int n6 = n3 + n5;
        while (this.pathBuf.length < n6) {
            this.growPathBuf(n3);
        }
        System.arraycopy(objectWalk$TreeVisit.buf, n4, this.pathBuf, n3, n5);
        return n6;
    }

    private void growPathBuf(int n2) {
        byte[] byArray = new byte[this.pathBuf.length << 1];
        System.arraycopy(this.pathBuf, 0, byArray, 0, n2);
        this.pathBuf = byArray;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.pendingObjects = new BlockObjQueue();
        this.currVisit = null;
        this.freeVisit = null;
    }

    @Override
    protected void reset(int n2) {
        super.reset(n2);
        for (RevObject revObject : this.rootObjects) {
            revObject.flags &= 0xFFFFFFF7;
        }
        this.rootObjects = new ArrayList();
        this.pendingObjects = new BlockObjQueue();
        this.currVisit = null;
        this.freeVisit = null;
    }

    private void addObject(RevObject revObject) {
        if ((revObject.flags & 8) == 0) {
            revObject.flags |= 8;
            this.rootObjects.add(revObject);
            this.pendingObjects.add(revObject);
        }
    }

    private void markTreeUninteresting(RevTree revTree) {
        if ((revTree.flags & 4) != 0) {
            return;
        }
        revTree.flags |= 4;
        byte[] byArray = this.reader.open(revTree, 2).getCachedBytes();
        block5: for (int i2 = 0; i2 < byArray.length; i2 += 20) {
            byte by = byArray[i2];
            int n2 = by - 48;
            while (32 != (by = byArray[++i2])) {
                n2 <<= 3;
                n2 += by - 48;
            }
            while (byArray[++i2] != 0) {
            }
            ++i2;
            switch (n2 >>> 12) {
                case 8: 
                case 10: {
                    this.idBuffer.fromRaw(byArray, i2);
                    this.lookupBlob((AnyObjectId)this.idBuffer).flags |= 4;
                    continue block5;
                }
                case 4: {
                    this.idBuffer.fromRaw(byArray, i2);
                    this.markTreeUninteresting(this.lookupTree(this.idBuffer));
                    continue block5;
                }
                case 14: {
                    continue block5;
                }
                default: {
                    this.idBuffer.fromRaw(byArray, i2);
                    throw new CorruptObjectException(MessageFormat.format(JGitText.get().corruptObjectInvalidMode3, String.format("%o", n2), this.idBuffer.name(), "", revTree));
                }
            }
        }
    }

    private RevObject pushTree(RevObject revObject) {
        ObjectWalk$TreeVisit objectWalk$TreeVisit = this.freeVisit;
        if (objectWalk$TreeVisit != null) {
            this.freeVisit = objectWalk$TreeVisit.parent;
            objectWalk$TreeVisit.ptr = 0;
            objectWalk$TreeVisit.namePtr = 0;
            objectWalk$TreeVisit.nameEnd = 0;
            objectWalk$TreeVisit.pathLen = 0;
        } else {
            objectWalk$TreeVisit = new ObjectWalk$TreeVisit();
        }
        objectWalk$TreeVisit.obj = revObject;
        objectWalk$TreeVisit.buf = this.reader.open(revObject, 2).getCachedBytes();
        objectWalk$TreeVisit.parent = this.currVisit;
        this.currVisit = objectWalk$TreeVisit;
        objectWalk$TreeVisit.depth = objectWalk$TreeVisit.parent == null ? 1 : objectWalk$TreeVisit.parent.depth + 1;
        return revObject;
    }

    private void releaseTreeVisit(ObjectWalk$TreeVisit objectWalk$TreeVisit) {
        objectWalk$TreeVisit.buf = null;
        objectWalk$TreeVisit.parent = this.freeVisit;
        this.freeVisit = objectWalk$TreeVisit;
    }
}

