/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.text.MessageFormat;
import java.util.LinkedList;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.revwalk.AbstractRevQueue;
import org.eclipse.jgit.revwalk.DateRevQueue;
import org.eclipse.jgit.revwalk.Generator;
import org.eclipse.jgit.revwalk.MergeBaseGenerator$CarryStack;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

class MergeBaseGenerator
extends Generator {
    private static final int PARSED = 1;
    private static final int IN_PENDING = 2;
    private static final int POPPED = 16;
    private static final int MERGE_BASE = 8;
    private final RevWalk walker;
    private final DateRevQueue pending;
    private int branchMask;
    private int recarryTest;
    private int recarryMask;
    private int mergeBaseAncestor = -1;
    private LinkedList ret = new LinkedList();
    private MergeBaseGenerator$CarryStack stack;
    private static final int CONTINUE = 0;
    private static final int HAVE_ALL = 1;
    private static final int CONTINUE_ON_STACK = 2;

    MergeBaseGenerator(RevWalk revWalk) {
        super(revWalk.isFirstParent());
        this.walker = revWalk;
        this.pending = new DateRevQueue(this.firstParent);
    }

    void init(AbstractRevQueue abstractRevQueue) {
        try {
            RevCommit revCommit;
            while ((revCommit = abstractRevQueue.next()) != null) {
                this.add(revCommit);
            }
            this.recarryTest = this.branchMask | 0x10;
            this.recarryMask = this.branchMask | 0x10 | 8;
            this.mergeBaseAncestor = this.walker.allocFlag();
            while ((revCommit = this._next()) != null) {
                this.ret.add(revCommit);
            }
        }
        finally {
            this.walker.freeFlag(this.branchMask | this.mergeBaseAncestor);
        }
    }

    private void add(RevCommit revCommit) {
        int n2 = this.walker.allocFlag();
        this.branchMask |= n2;
        if ((revCommit.flags & this.branchMask) != 0) {
            throw new IllegalStateException(MessageFormat.format(JGitText.get().staleRevFlagsOn, revCommit.name()));
        }
        revCommit.flags |= n2;
        this.pending.add(revCommit);
    }

    @Override
    int outputType() {
        return 0;
    }

    private RevCommit _next() {
        RevCommit revCommit;
        while (true) {
            if ((revCommit = this.pending.next()) == null) {
                return null;
            }
            RevCommit[] revCommitArray = revCommit.parents;
            int n2 = revCommitArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                RevCommit revCommit2 = revCommitArray[i2];
                if ((revCommit2.flags & 2) != 0) continue;
                if ((revCommit2.flags & 1) == 0) {
                    revCommit2.parseHeaders(this.walker);
                }
                revCommit2.flags |= 2;
                this.pending.add(revCommit2);
            }
            int n3 = revCommit.flags & this.branchMask;
            int n4 = n2 = n3 == this.branchMask ? 1 : 0;
            if (n2 != 0) {
                n3 |= 8 | this.mergeBaseAncestor;
            }
            this.carryOntoHistory(revCommit, n3);
            if ((revCommit.flags & 8) != 0) {
                if (!this.pending.everbodyHasFlag(8)) continue;
                return null;
            }
            revCommit.flags |= 0x10;
            if (n2 != 0) break;
        }
        revCommit.flags |= 8;
        return revCommit;
    }

    @Override
    RevCommit next() {
        while (!this.ret.isEmpty()) {
            RevCommit revCommit = (RevCommit)this.ret.remove();
            if ((revCommit.flags & this.mergeBaseAncestor) != 0) continue;
            return revCommit;
        }
        return null;
    }

    private void carryOntoHistory(RevCommit revCommit, int n2) {
        this.stack = null;
        while (true) {
            this.carryOntoHistoryInnerLoop(revCommit, n2);
            if (this.stack == null) break;
            revCommit = this.stack.c;
            n2 = this.stack.carry;
            this.stack = this.stack.prev;
        }
    }

    private void carryOntoHistoryInnerLoop(RevCommit revCommit, int n2) {
        RevCommit[] revCommitArray;
        while ((revCommitArray = revCommit.parents) != null && revCommitArray.length != 0) {
            int n3 = revCommitArray.length - 1;
            for (int i2 = 0; i2 < n3; ++i2) {
                RevCommit revCommit2 = revCommitArray[i2];
                if (this.carryOntoOne(revCommit2, n2) != 0) continue;
                this.stack = new MergeBaseGenerator$CarryStack(this.stack, revCommit2, n2);
            }
            revCommit = revCommitArray[n3];
            if (this.carryOntoOne(revCommit, n2) == 0) continue;
            break;
        }
    }

    private int carryOntoOne(RevCommit revCommit, int n2) {
        int n3 = (revCommit.flags & n2) == n2 ? 1 : 0;
        revCommit.flags |= n2;
        if ((revCommit.flags & this.recarryMask) == this.recarryTest) {
            revCommit.flags &= 0xFFFFFFEF;
            this.pending.add(revCommit);
            this.stack = new MergeBaseGenerator$CarryStack(this.stack, revCommit, this.branchMask | 8);
            return 2;
        }
        return n3;
    }
}

