/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import org.eclipse.jgit.revwalk.BlockRevQueue;
import org.eclipse.jgit.revwalk.BlockRevQueue$Block;
import org.eclipse.jgit.revwalk.Generator;
import org.eclipse.jgit.revwalk.RevCommit;

public class LIFORevQueue
extends BlockRevQueue {
    private BlockRevQueue$Block head;

    public LIFORevQueue() {
        super(false);
    }

    LIFORevQueue(Generator generator) {
        super(generator);
    }

    @Override
    public void add(RevCommit revCommit) {
        BlockRevQueue$Block blockRevQueue$Block = this.head;
        if (blockRevQueue$Block == null || !blockRevQueue$Block.canUnpop()) {
            blockRevQueue$Block = this.free.newBlock();
            blockRevQueue$Block.resetToEnd();
            blockRevQueue$Block.next = this.head;
            this.head = blockRevQueue$Block;
        }
        blockRevQueue$Block.unpop(revCommit);
    }

    @Override
    public RevCommit next() {
        BlockRevQueue$Block blockRevQueue$Block = this.head;
        if (blockRevQueue$Block == null) {
            return null;
        }
        RevCommit revCommit = blockRevQueue$Block.pop();
        if (blockRevQueue$Block.isEmpty()) {
            this.head = blockRevQueue$Block.next;
            this.free.freeBlock(blockRevQueue$Block);
        }
        return revCommit;
    }

    @Override
    public void clear() {
        this.head = null;
        this.free.clear();
    }

    @Override
    boolean everbodyHasFlag(int n2) {
        BlockRevQueue$Block blockRevQueue$Block = this.head;
        while (blockRevQueue$Block != null) {
            for (int i2 = blockRevQueue$Block.headIndex; i2 < blockRevQueue$Block.tailIndex; ++i2) {
                if ((blockRevQueue$Block.commits[i2].flags & n2) != 0) continue;
                return false;
            }
            blockRevQueue$Block = blockRevQueue$Block.next;
        }
        return true;
    }

    @Override
    boolean anybodyHasFlag(int n2) {
        BlockRevQueue$Block blockRevQueue$Block = this.head;
        while (blockRevQueue$Block != null) {
            for (int i2 = blockRevQueue$Block.headIndex; i2 < blockRevQueue$Block.tailIndex; ++i2) {
                if ((blockRevQueue$Block.commits[i2].flags & n2) == 0) continue;
                return true;
            }
            blockRevQueue$Block = blockRevQueue$Block.next;
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        BlockRevQueue$Block blockRevQueue$Block = this.head;
        while (blockRevQueue$Block != null) {
            for (int i2 = blockRevQueue$Block.headIndex; i2 < blockRevQueue$Block.tailIndex; ++i2) {
                LIFORevQueue.describe(stringBuilder, blockRevQueue$Block.commits[i2]);
            }
            blockRevQueue$Block = blockRevQueue$Block.next;
        }
        return stringBuilder.toString();
    }
}

