/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.nio.charset.Charset;
import org.eclipse.jgit.revwalk.FooterKey;
import org.eclipse.jgit.util.RawParseUtils;

public final class FooterLine {
    private final byte[] buffer;
    private final Charset enc;
    private final int keyStart;
    private final int keyEnd;
    private final int valStart;
    private final int valEnd;

    FooterLine(byte[] byArray, Charset charset, int n2, int n3, int n4, int n5) {
        this.buffer = byArray;
        this.enc = charset;
        this.keyStart = n2;
        this.keyEnd = n3;
        this.valStart = n4;
        this.valEnd = n5;
    }

    public boolean matches(FooterKey footerKey) {
        int n2 = this.keyStart;
        byte[] byArray = footerKey.raw;
        int n3 = byArray.length;
        if (this.keyEnd - n2 != n3) {
            return false;
        }
        int n4 = 0;
        while (n4 < n3) {
            byte by;
            if (65 <= (by = this.buffer[n2++]) && by <= 90) {
                by = (byte)(by + 32);
            }
            if (by == byArray[n4++]) continue;
            return false;
        }
        return true;
    }

    public String getKey() {
        return RawParseUtils.decode(this.enc, this.buffer, this.keyStart, this.keyEnd);
    }

    public String getValue() {
        return RawParseUtils.decode(this.enc, this.buffer, this.valStart, this.valEnd);
    }

    public String getEmailAddress() {
        int n2 = RawParseUtils.nextLF(this.buffer, this.valStart, '<');
        if (this.valEnd <= n2) {
            int n3 = RawParseUtils.nextLF(this.buffer, this.valStart, '@');
            if (this.valStart < n3 && n3 < this.valEnd) {
                return this.getValue();
            }
            return null;
        }
        int n4 = RawParseUtils.nextLF(this.buffer, n2, '>');
        if (this.valEnd < n4) {
            return null;
        }
        return RawParseUtils.decode(this.enc, this.buffer, n2, n4 - 1);
    }

    public String toString() {
        return this.getKey() + ": " + this.getValue();
    }
}

