/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import org.eclipse.jgit.diff.DiffConfig;
import org.eclipse.jgit.revwalk.RenameCallback;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public class FollowFilter
extends TreeFilter {
    private final PathFilter path;
    final DiffConfig cfg;
    private RenameCallback renameCallback;

    public static FollowFilter create(String string, DiffConfig diffConfig) {
        return new FollowFilter(PathFilter.create(string), diffConfig);
    }

    FollowFilter(PathFilter pathFilter, DiffConfig diffConfig) {
        this.path = pathFilter;
        this.cfg = diffConfig;
    }

    public String getPath() {
        return this.path.getPath();
    }

    @Override
    public boolean include(TreeWalk treeWalk) {
        return this.path.include(treeWalk) && ANY_DIFF.include(treeWalk);
    }

    @Override
    public boolean shouldBeRecursive() {
        return this.path.shouldBeRecursive() || ANY_DIFF.shouldBeRecursive();
    }

    @Override
    public TreeFilter clone() {
        return new FollowFilter(this.path.clone(), this.cfg);
    }

    @Override
    public String toString() {
        return "(FOLLOW(" + this.path.toString() + ") AND " + ANY_DIFF.toString() + ")";
    }

    public RenameCallback getRenameCallback() {
        return this.renameCallback;
    }

    public void setRenameCallback(RenameCallback renameCallback) {
        this.renameCallback = renameCallback;
    }
}

