/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import org.eclipse.jgit.revwalk.BlockRevQueue;
import org.eclipse.jgit.revwalk.BlockRevQueue$Block;
import org.eclipse.jgit.revwalk.Generator;
import org.eclipse.jgit.revwalk.RevCommit;

public class FIFORevQueue
extends BlockRevQueue {
    private BlockRevQueue$Block head;
    private BlockRevQueue$Block tail;

    public FIFORevQueue() {
        super(false);
    }

    FIFORevQueue(boolean bl2) {
        super(bl2);
    }

    FIFORevQueue(Generator generator) {
        super(generator);
    }

    @Override
    public void add(RevCommit revCommit) {
        BlockRevQueue$Block blockRevQueue$Block = this.tail;
        if (blockRevQueue$Block == null) {
            blockRevQueue$Block = this.free.newBlock();
            blockRevQueue$Block.add(revCommit);
            this.head = blockRevQueue$Block;
            this.tail = blockRevQueue$Block;
            return;
        }
        if (blockRevQueue$Block.isFull()) {
            this.tail.next = blockRevQueue$Block = this.free.newBlock();
            this.tail = blockRevQueue$Block;
        }
        blockRevQueue$Block.add(revCommit);
    }

    public void unpop(RevCommit revCommit) {
        BlockRevQueue$Block blockRevQueue$Block = this.head;
        if (blockRevQueue$Block == null) {
            blockRevQueue$Block = this.free.newBlock();
            blockRevQueue$Block.resetToMiddle();
            blockRevQueue$Block.add(revCommit);
            this.head = blockRevQueue$Block;
            this.tail = blockRevQueue$Block;
            return;
        }
        if (blockRevQueue$Block.canUnpop()) {
            blockRevQueue$Block.unpop(revCommit);
            return;
        }
        blockRevQueue$Block = this.free.newBlock();
        blockRevQueue$Block.resetToEnd();
        blockRevQueue$Block.unpop(revCommit);
        blockRevQueue$Block.next = this.head;
        this.head = blockRevQueue$Block;
    }

    @Override
    public RevCommit next() {
        BlockRevQueue$Block blockRevQueue$Block = this.head;
        if (blockRevQueue$Block == null) {
            return null;
        }
        RevCommit revCommit = blockRevQueue$Block.pop();
        if (blockRevQueue$Block.isEmpty()) {
            this.head = blockRevQueue$Block.next;
            if (this.head == null) {
                this.tail = null;
            }
            this.free.freeBlock(blockRevQueue$Block);
        }
        return revCommit;
    }

    @Override
    public void clear() {
        this.head = null;
        this.tail = null;
        this.free.clear();
    }

    @Override
    boolean everbodyHasFlag(int n2) {
        BlockRevQueue$Block blockRevQueue$Block = this.head;
        while (blockRevQueue$Block != null) {
            for (int i2 = blockRevQueue$Block.headIndex; i2 < blockRevQueue$Block.tailIndex; ++i2) {
                if ((blockRevQueue$Block.commits[i2].flags & n2) != 0) continue;
                return false;
            }
            blockRevQueue$Block = blockRevQueue$Block.next;
        }
        return true;
    }

    @Override
    boolean anybodyHasFlag(int n2) {
        BlockRevQueue$Block blockRevQueue$Block = this.head;
        while (blockRevQueue$Block != null) {
            for (int i2 = blockRevQueue$Block.headIndex; i2 < blockRevQueue$Block.tailIndex; ++i2) {
                if ((blockRevQueue$Block.commits[i2].flags & n2) == 0) continue;
                return true;
            }
            blockRevQueue$Block = blockRevQueue$Block.next;
        }
        return false;
    }

    void removeFlag(int n2) {
        int n3 = ~n2;
        BlockRevQueue$Block blockRevQueue$Block = this.head;
        while (blockRevQueue$Block != null) {
            for (int i2 = blockRevQueue$Block.headIndex; i2 < blockRevQueue$Block.tailIndex; ++i2) {
                blockRevQueue$Block.commits[i2].flags &= n3;
            }
            blockRevQueue$Block = blockRevQueue$Block.next;
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        BlockRevQueue$Block blockRevQueue$Block = this.head;
        while (blockRevQueue$Block != null) {
            for (int i2 = blockRevQueue$Block.headIndex; i2 < blockRevQueue$Block.tailIndex; ++i2) {
                FIFORevQueue.describe(stringBuilder, blockRevQueue$Block.commits[i2]);
            }
            blockRevQueue$Block = blockRevQueue$Block.next;
        }
        return stringBuilder.toString();
    }
}

