/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.DepthWalk;
import org.eclipse.jgit.revwalk.DepthWalk$Commit;
import org.eclipse.jgit.revwalk.DepthWalk$ObjectWalk;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevWalk;

public class DepthWalk$RevWalk
extends RevWalk
implements DepthWalk {
    private final int depth;
    private int deepenSince;
    private List deepenNots;
    private final RevFlag UNSHALLOW;
    private final RevFlag REINTERESTING;
    private final RevFlag DEEPEN_NOT;

    public DepthWalk$RevWalk(Repository repository, int n2) {
        super(repository);
        this.depth = n2;
        this.deepenNots = Collections.emptyList();
        this.UNSHALLOW = this.newFlag("UNSHALLOW");
        this.REINTERESTING = this.newFlag("REINTERESTING");
        this.DEEPEN_NOT = this.newFlag("DEEPEN_NOT");
    }

    public DepthWalk$RevWalk(ObjectReader objectReader, int n2) {
        super(objectReader);
        this.depth = n2;
        this.deepenNots = Collections.emptyList();
        this.UNSHALLOW = this.newFlag("UNSHALLOW");
        this.REINTERESTING = this.newFlag("REINTERESTING");
        this.DEEPEN_NOT = this.newFlag("DEEPEN_NOT");
    }

    public void markRoot(RevCommit revCommit) {
        if (revCommit instanceof DepthWalk$Commit) {
            ((DepthWalk$Commit)revCommit).depth = 0;
        }
        super.markStart(revCommit);
    }

    @Override
    protected RevCommit createCommit(AnyObjectId anyObjectId) {
        return new DepthWalk$Commit(anyObjectId);
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public int getDeepenSince() {
        return this.deepenSince;
    }

    public void setDeepenSince(int n2) {
        this.deepenSince = n2;
    }

    @Override
    public List getDeepenNots() {
        return this.deepenNots;
    }

    public void setDeepenNots(List list) {
        this.deepenNots = Objects.requireNonNull(list);
    }

    @Override
    public RevFlag getUnshallowFlag() {
        return this.UNSHALLOW;
    }

    @Override
    public RevFlag getReinterestingFlag() {
        return this.REINTERESTING;
    }

    @Override
    public RevFlag getDeepenNotFlag() {
        return this.DEEPEN_NOT;
    }

    @Override
    public DepthWalk$ObjectWalk toObjectWalkWithSameObjects() {
        DepthWalk$ObjectWalk depthWalk$ObjectWalk = new DepthWalk$ObjectWalk(this.reader, this.depth);
        DepthWalk$ObjectWalk.access$002(depthWalk$ObjectWalk, this.deepenSince);
        DepthWalk$ObjectWalk.access$102(depthWalk$ObjectWalk, this.deepenNots);
        depthWalk$ObjectWalk.objects = this.objects;
        depthWalk$ObjectWalk.freeFlags = this.freeFlags;
        return depthWalk$ObjectWalk;
    }
}

