/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.util.Collections;
import java.util.List;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.DepthWalk;
import org.eclipse.jgit.revwalk.DepthWalk$Commit;
import org.eclipse.jgit.revwalk.ObjectWalk;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;

public class DepthWalk$ObjectWalk
extends ObjectWalk
implements DepthWalk {
    private final int depth;
    private int deepenSince;
    private List deepenNots;
    private final RevFlag UNSHALLOW;
    private final RevFlag REINTERESTING;
    private final RevFlag DEEPEN_NOT;

    public DepthWalk$ObjectWalk(Repository repository, int n2) {
        super(repository);
        this.depth = n2;
        this.deepenNots = Collections.emptyList();
        this.UNSHALLOW = this.newFlag("UNSHALLOW");
        this.REINTERESTING = this.newFlag("REINTERESTING");
        this.DEEPEN_NOT = this.newFlag("DEEPEN_NOT");
    }

    public DepthWalk$ObjectWalk(ObjectReader objectReader, int n2) {
        super(objectReader);
        this.depth = n2;
        this.deepenNots = Collections.emptyList();
        this.UNSHALLOW = this.newFlag("UNSHALLOW");
        this.REINTERESTING = this.newFlag("REINTERESTING");
        this.DEEPEN_NOT = this.newFlag("DEEPEN_NOT");
    }

    public void markRoot(RevObject revObject) {
        RevObject revObject2 = revObject;
        while (revObject2 instanceof RevTag) {
            revObject2 = ((RevTag)revObject2).getObject();
            this.parseHeaders(revObject2);
        }
        if (revObject2 instanceof DepthWalk$Commit) {
            ((DepthWalk$Commit)revObject2).depth = 0;
        }
        super.markStart(revObject);
    }

    public void markUnshallow(RevObject revObject) {
        if (revObject instanceof RevCommit) {
            revObject.add(this.UNSHALLOW);
        }
        super.markStart(revObject);
    }

    @Override
    protected RevCommit createCommit(AnyObjectId anyObjectId) {
        return new DepthWalk$Commit(anyObjectId);
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public int getDeepenSince() {
        return this.deepenSince;
    }

    @Override
    public List getDeepenNots() {
        return this.deepenNots;
    }

    @Override
    public RevFlag getUnshallowFlag() {
        return this.UNSHALLOW;
    }

    @Override
    public RevFlag getReinterestingFlag() {
        return this.REINTERESTING;
    }

    @Override
    public RevFlag getDeepenNotFlag() {
        return this.DEEPEN_NOT;
    }

    static /* synthetic */ int access$002(DepthWalk$ObjectWalk depthWalk$ObjectWalk, int n2) {
        depthWalk$ObjectWalk.deepenSince = n2;
        return depthWalk$ObjectWalk.deepenSince;
    }

    static /* synthetic */ List access$102(DepthWalk$ObjectWalk depthWalk$ObjectWalk, List list) {
        depthWalk$ObjectWalk.deepenNots = list;
        return depthWalk$ObjectWalk.deepenNots;
    }
}

