/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.BlockRevQueue;
import org.eclipse.jgit.revwalk.DepthWalk;
import org.eclipse.jgit.revwalk.DepthWalk$Commit;
import org.eclipse.jgit.revwalk.FIFORevQueue;
import org.eclipse.jgit.revwalk.Generator;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;

class DepthGenerator
extends Generator {
    private final FIFORevQueue pending;
    private final int depth;
    private final int deepenSince;
    private final RevWalk walk;
    private final RevFlag UNSHALLOW;
    private final RevFlag REINTERESTING;
    private final RevFlag DEEPEN_NOT;

    DepthGenerator(DepthWalk depthWalk, Generator generator) {
        super(generator.firstParent);
        Object object;
        this.pending = new FIFORevQueue(this.firstParent);
        this.walk = (RevWalk)((Object)depthWalk);
        this.depth = depthWalk.getDepth();
        this.deepenSince = depthWalk.getDeepenSince();
        this.UNSHALLOW = depthWalk.getUnshallowFlag();
        this.REINTERESTING = depthWalk.getReinterestingFlag();
        this.DEEPEN_NOT = depthWalk.getDeepenNotFlag();
        generator.shareFreeList(this.pending);
        FIFORevQueue fIFORevQueue = new FIFORevQueue();
        while ((object = generator.next()) != null) {
            if (((RevObject)object).has(this.UNSHALLOW)) {
                fIFORevQueue.add((RevCommit)object);
                continue;
            }
            if (((DepthWalk$Commit)object).getDepth() != 0) continue;
            this.pending.add((RevCommit)object);
        }
        while ((object = fIFORevQueue.next()) != null) {
            this.pending.unpop((RevCommit)object);
        }
        for (ObjectId objectId : depthWalk.getDeepenNots()) {
            RevCommit revCommit;
            try {
                revCommit = this.walk.parseCommit(objectId);
            }
            catch (IncorrectObjectTypeException incorrectObjectTypeException) {
                continue;
            }
            FIFORevQueue fIFORevQueue2 = new FIFORevQueue();
            fIFORevQueue2.add(revCommit);
            while ((revCommit = fIFORevQueue2.next()) != null) {
                if (revCommit.has(this.DEEPEN_NOT)) continue;
                this.walk.parseHeaders(revCommit);
                revCommit.add(this.DEEPEN_NOT);
                for (RevCommit revCommit2 : revCommit.getParents()) {
                    fIFORevQueue2.add(revCommit2);
                }
            }
        }
    }

    @Override
    int outputType() {
        return this.pending.outputType() | 0x10;
    }

    @Override
    void shareFreeList(BlockRevQueue blockRevQueue) {
        this.pending.shareFreeList(blockRevQueue);
    }

    @Override
    RevCommit next() {
        DepthWalk$Commit depthWalk$Commit;
        while (true) {
            int n2;
            if ((depthWalk$Commit = (DepthWalk$Commit)this.pending.next()) == null) {
                return null;
            }
            if ((depthWalk$Commit.flags & 1) == 0) {
                depthWalk$Commit.parseHeaders(this.walk);
            }
            if (depthWalk$Commit.getCommitTime() < this.deepenSince || depthWalk$Commit.has(this.DEEPEN_NOT)) continue;
            int n3 = depthWalk$Commit.depth + 1;
            for (n2 = 0; !(n2 >= depthWalk$Commit.parents.length || this.firstParent && n2 > 0); ++n2) {
                RevCommit revCommit = depthWalk$Commit.parents[n2];
                DepthWalk$Commit depthWalk$Commit2 = (DepthWalk$Commit)revCommit;
                if (depthWalk$Commit2.depth == -1) {
                    boolean bl2 = false;
                    if (this.deepenSince != 0) {
                        if ((revCommit.flags & 1) == 0) {
                            revCommit.parseHeaders(this.walk);
                        }
                        bl2 = revCommit.getCommitTime() < this.deepenSince;
                    }
                    depthWalk$Commit2.depth = n3;
                    if (n3 <= this.depth && !bl2 && !revCommit.has(this.DEEPEN_NOT)) {
                        this.pending.add(revCommit);
                    } else {
                        depthWalk$Commit2.makesChildBoundary = true;
                    }
                }
                if (depthWalk$Commit2.makesChildBoundary) {
                    depthWalk$Commit.isBoundary = true;
                }
                if (!depthWalk$Commit.has(this.UNSHALLOW) && !depthWalk$Commit.has(this.REINTERESTING)) continue;
                revCommit.add(this.REINTERESTING);
                revCommit.flags &= 0xFFFFFFFB;
            }
            n2 = 1;
            if ((depthWalk$Commit.flags & 4) != 0 && !depthWalk$Commit.has(this.UNSHALLOW)) {
                n2 = 0;
            }
            if (depthWalk$Commit.getCommitTime() < this.deepenSince) {
                n2 = 0;
            }
            if (n2 != 0) break;
        }
        return depthWalk$Commit;
    }
}

