/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import org.eclipse.jgit.revwalk.FIFORevQueue;
import org.eclipse.jgit.revwalk.Generator;
import org.eclipse.jgit.revwalk.RevCommit;

final class DelayRevQueue
extends Generator {
    private static final int OVER_SCAN = 6;
    private final Generator pending;
    private final FIFORevQueue delay;
    private int size;

    DelayRevQueue(Generator generator) {
        super(generator.firstParent);
        this.pending = generator;
        this.delay = new FIFORevQueue();
    }

    @Override
    int outputType() {
        return this.pending.outputType();
    }

    @Override
    RevCommit next() {
        RevCommit revCommit;
        while (this.size < 6 && (revCommit = this.pending.next()) != null) {
            this.delay.add(revCommit);
            ++this.size;
        }
        revCommit = this.delay.next();
        if (revCommit == null) {
            return null;
        }
        --this.size;
        return revCommit;
    }
}

