/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import org.eclipse.jgit.revwalk.AbstractRevQueue;
import org.eclipse.jgit.revwalk.DateRevQueue$Entry;
import org.eclipse.jgit.revwalk.Generator;
import org.eclipse.jgit.revwalk.RevCommit;

public class DateRevQueue
extends AbstractRevQueue {
    private static final int REBUILD_INDEX_COUNT = 1000;
    private DateRevQueue$Entry head;
    private DateRevQueue$Entry free;
    private int inQueue;
    private int sinceLastIndex;
    private DateRevQueue$Entry[] index;
    private int first;
    private int last = -1;

    public DateRevQueue() {
        super(false);
    }

    DateRevQueue(boolean bl2) {
        super(bl2);
    }

    DateRevQueue(Generator generator) {
        super(generator.firstParent);
        RevCommit revCommit;
        while ((revCommit = generator.next()) != null) {
            this.add(revCommit);
        }
    }

    @Override
    public void add(RevCommit revCommit) {
        ++this.sinceLastIndex;
        if (++this.inQueue > 1000 && this.sinceLastIndex > 1000) {
            this.buildIndex();
        }
        DateRevQueue$Entry dateRevQueue$Entry = this.head;
        long l2 = revCommit.commitTime;
        if (this.first <= this.last && (long)this.index[this.first].commit.commitTime > l2) {
            int n2 = this.first;
            int n3 = this.last;
            while (n2 <= n3) {
                int n4 = n2 + n3 >>> 1;
                int n5 = this.index[n4].commit.commitTime;
                if ((long)n5 < l2) {
                    n3 = n4 - 1;
                    continue;
                }
                if ((long)n5 > l2) {
                    n2 = n4 + 1;
                    continue;
                }
                n2 = n4 - 1;
                break;
            }
            for (n2 = Math.min(n2, n3); n2 > this.first && l2 == (long)this.index[n2].commit.commitTime; --n2) {
            }
            dateRevQueue$Entry = this.index[n2];
        }
        DateRevQueue$Entry dateRevQueue$Entry2 = this.newEntry(revCommit);
        if (dateRevQueue$Entry == null || dateRevQueue$Entry == this.head && l2 > (long)dateRevQueue$Entry.commit.commitTime) {
            dateRevQueue$Entry2.next = dateRevQueue$Entry;
            this.head = dateRevQueue$Entry2;
        } else {
            DateRevQueue$Entry dateRevQueue$Entry3 = dateRevQueue$Entry.next;
            while (dateRevQueue$Entry3 != null && (long)dateRevQueue$Entry3.commit.commitTime >= l2) {
                dateRevQueue$Entry = dateRevQueue$Entry3;
                dateRevQueue$Entry3 = dateRevQueue$Entry.next;
            }
            dateRevQueue$Entry2.next = dateRevQueue$Entry.next;
            dateRevQueue$Entry.next = dateRevQueue$Entry2;
        }
    }

    @Override
    public RevCommit next() {
        DateRevQueue$Entry dateRevQueue$Entry = this.head;
        if (dateRevQueue$Entry == null) {
            return null;
        }
        if (this.index != null && dateRevQueue$Entry == this.index[this.first]) {
            this.index[this.first++] = null;
        }
        --this.inQueue;
        this.head = dateRevQueue$Entry.next;
        this.freeEntry(dateRevQueue$Entry);
        return dateRevQueue$Entry.commit;
    }

    private void buildIndex() {
        this.sinceLastIndex = 0;
        this.first = 0;
        this.index = new DateRevQueue$Entry[this.inQueue / 100 + 1];
        int n2 = 0;
        int n3 = 0;
        DateRevQueue$Entry dateRevQueue$Entry = this.head;
        while (dateRevQueue$Entry != null) {
            if (++n2 % 100 == 0) {
                this.index[n3++] = dateRevQueue$Entry;
            }
            dateRevQueue$Entry = dateRevQueue$Entry.next;
        }
        this.last = n3 - 1;
    }

    public RevCommit peek() {
        return this.head != null ? this.head.commit : null;
    }

    @Override
    public void clear() {
        this.head = null;
        this.free = null;
        this.index = null;
        this.inQueue = 0;
        this.sinceLastIndex = 0;
        this.last = -1;
    }

    @Override
    boolean everbodyHasFlag(int n2) {
        DateRevQueue$Entry dateRevQueue$Entry = this.head;
        while (dateRevQueue$Entry != null) {
            if ((dateRevQueue$Entry.commit.flags & n2) == 0) {
                return false;
            }
            dateRevQueue$Entry = dateRevQueue$Entry.next;
        }
        return true;
    }

    @Override
    boolean anybodyHasFlag(int n2) {
        DateRevQueue$Entry dateRevQueue$Entry = this.head;
        while (dateRevQueue$Entry != null) {
            if ((dateRevQueue$Entry.commit.flags & n2) != 0) {
                return true;
            }
            dateRevQueue$Entry = dateRevQueue$Entry.next;
        }
        return false;
    }

    @Override
    int outputType() {
        return this.outputType | 1;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        DateRevQueue$Entry dateRevQueue$Entry = this.head;
        while (dateRevQueue$Entry != null) {
            DateRevQueue.describe(stringBuilder, dateRevQueue$Entry.commit);
            dateRevQueue$Entry = dateRevQueue$Entry.next;
        }
        return stringBuilder.toString();
    }

    private DateRevQueue$Entry newEntry(RevCommit revCommit) {
        DateRevQueue$Entry dateRevQueue$Entry = this.free;
        if (dateRevQueue$Entry == null) {
            dateRevQueue$Entry = new DateRevQueue$Entry();
        } else {
            this.free = dateRevQueue$Entry.next;
        }
        dateRevQueue$Entry.commit = revCommit;
        return dateRevQueue$Entry;
    }

    private void freeEntry(DateRevQueue$Entry dateRevQueue$Entry) {
        dateRevQueue$Entry.next = this.free;
        this.free = dateRevQueue$Entry;
    }
}

