/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import org.eclipse.jgit.revwalk.RevCommit;

final class BlockRevQueue$Block {
    static final int BLOCK_SIZE = 256;
    BlockRevQueue$Block next;
    final RevCommit[] commits = new RevCommit[256];
    int headIndex;
    int tailIndex;

    BlockRevQueue$Block() {
    }

    boolean isFull() {
        return this.tailIndex == 256;
    }

    boolean isEmpty() {
        return this.headIndex == this.tailIndex;
    }

    boolean canUnpop() {
        return this.headIndex > 0;
    }

    void add(RevCommit revCommit) {
        this.commits[this.tailIndex++] = revCommit;
    }

    void unpop(RevCommit revCommit) {
        this.commits[--this.headIndex] = revCommit;
    }

    RevCommit pop() {
        return this.commits[this.headIndex++];
    }

    RevCommit peek() {
        return this.commits[this.headIndex];
    }

    void clear() {
        this.next = null;
        this.headIndex = 0;
        this.tailIndex = 0;
    }

    void resetToMiddle() {
        this.tailIndex = 128;
        this.headIndex = 128;
    }

    void resetToEnd() {
        this.tailIndex = 256;
        this.headIndex = 256;
    }
}

