/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.util.Arrays;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.revwalk.AddToBitmapFilter;
import org.eclipse.jgit.internal.revwalk.AddToBitmapWithCacheFilter;
import org.eclipse.jgit.internal.revwalk.AddUnseenToBitmapFilter;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BitmapIndex;
import org.eclipse.jgit.lib.BitmapIndex$Bitmap;
import org.eclipse.jgit.lib.BitmapIndex$BitmapBuilder;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.revwalk.BitmapWalker$BitmapObjectFilter;
import org.eclipse.jgit.revwalk.ObjectWalk;
import org.eclipse.jgit.revwalk.RevObject;

public final class BitmapWalker {
    private final ObjectWalk walker;
    private final BitmapIndex bitmapIndex;
    private final ProgressMonitor pm;
    private long countOfBitmapIndexMisses;
    private AnyObjectId prevCommit;
    private BitmapIndex$Bitmap prevBitmap;

    public BitmapWalker(ObjectWalk objectWalk, BitmapIndex bitmapIndex, ProgressMonitor progressMonitor) {
        this.walker = objectWalk;
        this.bitmapIndex = bitmapIndex;
        this.pm = progressMonitor == null ? NullProgressMonitor.INSTANCE : progressMonitor;
    }

    public void setPrevCommit(AnyObjectId anyObjectId) {
        this.prevCommit = anyObjectId;
    }

    public void setPrevBitmap(BitmapIndex$Bitmap bitmapIndex$Bitmap) {
        this.prevBitmap = bitmapIndex$Bitmap;
    }

    public long getCountOfBitmapIndexMisses() {
        return this.countOfBitmapIndexMisses;
    }

    public BitmapIndex$BitmapBuilder findObjects(Iterable iterable, BitmapIndex$BitmapBuilder bitmapIndex$BitmapBuilder, boolean bl2) {
        if (!bl2) {
            return this.findObjectsWalk(iterable, bitmapIndex$BitmapBuilder, false);
        }
        try {
            return this.findObjectsWalk(iterable, bitmapIndex$BitmapBuilder, true);
        }
        catch (MissingObjectException missingObjectException) {
            BitmapIndex$BitmapBuilder bitmapIndex$BitmapBuilder2 = this.bitmapIndex.newBitmapBuilder();
            for (ObjectId objectId : iterable) {
                BitmapIndex$Bitmap bitmapIndex$Bitmap = this.bitmapIndex.getBitmap(objectId);
                if (bitmapIndex$Bitmap == null) continue;
                bitmapIndex$BitmapBuilder2.or(bitmapIndex$Bitmap);
            }
            for (ObjectId objectId : iterable) {
                if (bitmapIndex$BitmapBuilder2.contains(objectId)) continue;
                try {
                    bitmapIndex$BitmapBuilder2.or(this.findObjectsWalk(Arrays.asList(objectId), bitmapIndex$BitmapBuilder2, false));
                }
                catch (MissingObjectException missingObjectException2) {}
            }
            return bitmapIndex$BitmapBuilder2;
        }
    }

    private BitmapIndex$BitmapBuilder findObjectsWalk(Iterable iterable, BitmapIndex$BitmapBuilder bitmapIndex$BitmapBuilder, boolean bl2) {
        Object object;
        Object object22;
        this.walker.reset();
        BitmapIndex$BitmapBuilder bitmapIndex$BitmapBuilder2 = this.bitmapIndex.newBitmapBuilder();
        for (Object object22 : iterable) {
            object = this.bitmapIndex.getBitmap((AnyObjectId)object22);
            if (object == null) continue;
            bitmapIndex$BitmapBuilder2.or((BitmapIndex$Bitmap)object);
        }
        boolean bl3 = false;
        object22 = iterable.iterator();
        while (object22.hasNext()) {
            object = (ObjectId)object22.next();
            try {
                if (bitmapIndex$BitmapBuilder2.contains((AnyObjectId)object)) continue;
                this.walker.markStart(this.walker.parseAny((AnyObjectId)object));
                bl3 = true;
            }
            catch (MissingObjectException missingObjectException) {
                if (bl2) continue;
                throw missingObjectException;
            }
        }
        if (bl3) {
            if (this.prevCommit != null) {
                this.walker.setRevFilter(new AddToBitmapWithCacheFilter(this.prevCommit, this.prevBitmap, bitmapIndex$BitmapBuilder2));
            } else if (bitmapIndex$BitmapBuilder == null) {
                this.walker.setRevFilter(new AddToBitmapFilter(bitmapIndex$BitmapBuilder2));
            } else {
                this.walker.setRevFilter(new AddUnseenToBitmapFilter(bitmapIndex$BitmapBuilder, bitmapIndex$BitmapBuilder2));
            }
            this.walker.setObjectFilter(new BitmapWalker$BitmapObjectFilter(bitmapIndex$BitmapBuilder2));
            while (this.walker.next() != null) {
                this.pm.update(1);
                ++this.countOfBitmapIndexMisses;
            }
            while ((object22 = this.walker.nextObject()) != null) {
                bitmapIndex$BitmapBuilder2.addObject((AnyObjectId)object22, ((RevObject)object22).getType());
                this.pm.update(1);
            }
        }
        return bitmapIndex$BitmapBuilder2;
    }
}

