/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revplot;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revplot.PlotCommit;
import org.eclipse.jgit.revplot.PlotWalk$PlotRefComparator;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevWalk;

public class PlotWalk
extends RevWalk {
    private Map additionalRefMap;
    private Map reverseRefMap;
    private Repository repository;

    @Override
    public void dispose() {
        super.dispose();
        if (this.reverseRefMap != null) {
            this.reverseRefMap.clear();
            this.reverseRefMap = null;
        }
        if (this.additionalRefMap != null) {
            this.additionalRefMap.clear();
            this.additionalRefMap = null;
        }
        this.repository = null;
    }

    public PlotWalk(Repository repository) {
        super(repository);
        super.sort(RevSort.TOPO, true);
        this.additionalRefMap = new HashMap();
        this.repository = repository;
    }

    public void addAdditionalRefs(Iterable iterable) {
        for (Ref ref : iterable) {
            Set<Ref> set = (Set<Ref>)this.additionalRefMap.get(ref.getObjectId());
            if (set == null) {
                set = Collections.singleton(ref);
            } else {
                set = new HashSet<Ref>(set);
                set.add(ref);
            }
            this.additionalRefMap.put(ref.getObjectId(), set);
        }
    }

    @Override
    public void sort(RevSort revSort, boolean bl2) {
        if (revSort == RevSort.TOPO && !bl2) {
            throw new IllegalArgumentException(JGitText.get().topologicalSortRequired);
        }
        super.sort(revSort, bl2);
    }

    @Override
    protected RevCommit createCommit(AnyObjectId anyObjectId) {
        return new PlotCommit(anyObjectId);
    }

    @Override
    public RevCommit next() {
        PlotCommit plotCommit = (PlotCommit)super.next();
        if (plotCommit != null) {
            plotCommit.refs = this.getRefs(plotCommit);
        }
        return plotCommit;
    }

    private Ref[] getRefs(AnyObjectId anyObjectId) {
        Object object;
        Object object2;
        if (this.reverseRefMap == null) {
            this.reverseRefMap = this.repository.getAllRefsByPeeledObjectId();
            object2 = this.additionalRefMap.entrySet().iterator();
            while (object2.hasNext()) {
                object = (Map.Entry)object2.next();
                Set set = (Set)this.reverseRefMap.get(object.getKey());
                HashSet hashSet = (HashSet)object.getValue();
                if (set != null) {
                    if (hashSet.size() == 1) {
                        hashSet = new HashSet(hashSet);
                    }
                    hashSet.addAll(set);
                }
                this.reverseRefMap.put(object.getKey(), hashSet);
            }
            this.additionalRefMap.clear();
            this.additionalRefMap = null;
        }
        if ((object2 = (Collection)this.reverseRefMap.get(anyObjectId)) == null) {
            return PlotCommit.NO_REFS;
        }
        object = object2.toArray(new Ref[0]);
        Arrays.sort(object, new PlotWalk$PlotRefComparator(this));
        return object;
    }
}

