/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revplot;

import java.io.IOException;
import java.util.Comparator;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revplot.PlotWalk;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;

class PlotWalk$PlotRefComparator
implements Comparator {
    final /* synthetic */ PlotWalk this$0;

    PlotWalk$PlotRefComparator(PlotWalk plotWalk) {
        this.this$0 = plotWalk;
    }

    public int compare(Ref ref, Ref ref2) {
        try {
            RevObject revObject = this.this$0.parseAny(ref.getObjectId());
            RevObject revObject2 = this.this$0.parseAny(ref2.getObjectId());
            long l2 = this.timeof(revObject);
            long l3 = this.timeof(revObject2);
            if (l2 > l3) {
                return -1;
            }
            if (l2 < l3) {
                return 1;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        int n2 = this.kind(ref) - this.kind(ref2);
        if (n2 == 0) {
            n2 = ref.getName().compareTo(ref2.getName());
        }
        return n2;
    }

    long timeof(RevObject revObject) {
        if (revObject instanceof RevCommit) {
            return ((RevCommit)revObject).getCommitTime();
        }
        if (revObject instanceof RevTag) {
            RevTag revTag = (RevTag)revObject;
            try {
                this.this$0.parseBody(revTag);
            }
            catch (IOException iOException) {
                return 0L;
            }
            PersonIdent personIdent = revTag.getTaggerIdent();
            return personIdent != null ? personIdent.getWhen().getTime() : 0L;
        }
        return 0L;
    }

    int kind(Ref ref) {
        if (ref.getName().startsWith("refs/tags/")) {
            return 0;
        }
        if (ref.getName().startsWith("refs/heads/")) {
            return 1;
        }
        if (ref.getName().startsWith("refs/remotes/")) {
            return 2;
        }
        return 3;
    }
}

