/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revplot;

import java.text.MessageFormat;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeSet;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.revplot.PlotCommit;
import org.eclipse.jgit.revplot.PlotLane;
import org.eclipse.jgit.revplot.PlotWalk;
import org.eclipse.jgit.revwalk.RevCommitList;
import org.eclipse.jgit.revwalk.RevWalk;

public class PlotCommitList
extends RevCommitList {
    static final int MAX_LENGTH = 25;
    private int positionsAllocated;
    private final TreeSet freePositions = new TreeSet();
    private final HashSet activeLanes = new HashSet(32);
    private final HashMap laneLength = new HashMap(32);

    @Override
    public void clear() {
        super.clear();
        this.positionsAllocated = 0;
        this.freePositions.clear();
        this.activeLanes.clear();
        this.laneLength.clear();
    }

    @Override
    public void source(RevWalk revWalk) {
        if (!(revWalk instanceof PlotWalk)) {
            throw new ClassCastException(MessageFormat.format(JGitText.get().classCastNotA, PlotWalk.class.getName()));
        }
        super.source(revWalk);
    }

    public void findPassingThrough(PlotCommit plotCommit, Collection collection) {
        for (PlotLane plotLane : plotCommit.passingLanes) {
            collection.add(plotLane);
        }
    }

    protected void enter(int n2, PlotCommit plotCommit) {
        this.setupChildren(plotCommit);
        int n3 = plotCommit.getChildCount();
        if (n3 == 0) {
            plotCommit.lane = this.nextFreeLane();
        } else if (n3 == 1 && plotCommit.children[0].getParentCount() < 2) {
            PlotCommit plotCommit2 = plotCommit.children[0];
            plotCommit.lane = plotCommit2.lane;
            Integer n4 = (Integer)this.laneLength.get(plotCommit.lane);
            n4 = n4 != null ? Integer.valueOf(n4 + 1) : Integer.valueOf(0);
            this.laneLength.put(plotCommit.lane, n4);
        } else {
            Comparable<Integer> comparable;
            PlotCommit plotCommit3;
            int n5;
            PlotLane plotLane = null;
            PlotCommit plotCommit4 = null;
            int n6 = -1;
            for (n5 = 0; n5 < n3; ++n5) {
                plotCommit3 = plotCommit.children[n5];
                if (plotCommit3.getParent(0) != plotCommit || (Integer)(comparable = (Integer)this.laneLength.get(plotCommit3.lane)) <= n6) continue;
                plotLane = plotCommit3.lane;
                plotCommit4 = plotCommit3;
                n6 = (Integer)comparable;
            }
            if (plotLane != null) {
                plotCommit.lane = plotLane;
                this.laneLength.put(plotLane, n6 + 1);
                this.handleBlockedLanes(n2, plotCommit, plotCommit4);
            } else {
                plotCommit.lane = this.nextFreeLane();
                this.handleBlockedLanes(n2, plotCommit, null);
            }
            for (n5 = 0; n5 < n3; ++n5) {
                plotCommit3 = plotCommit.children[n5];
                comparable = (PlotCommit)plotCommit3.getParent(0);
                if (((PlotCommit)comparable).lane == null || ((PlotCommit)comparable).lane == plotCommit3.lane) continue;
                this.closeLane(plotCommit3.lane);
            }
        }
        this.continueActiveLanes(plotCommit);
        if (plotCommit.getParentCount() == 0) {
            this.closeLane(plotCommit.lane);
        }
    }

    private void continueActiveLanes(PlotCommit plotCommit) {
        for (PlotLane plotLane : this.activeLanes) {
            if (plotLane == plotCommit.lane) continue;
            plotCommit.addPassingLane(plotLane);
        }
    }

    private void handleBlockedLanes(int n2, PlotCommit plotCommit, PlotCommit plotCommit2) {
        for (PlotCommit plotCommit3 : plotCommit.children) {
            PlotLane plotLane;
            boolean bl2;
            if (plotCommit3 == plotCommit2) continue;
            boolean bl3 = bl2 = plotCommit3.getParent(0) != plotCommit;
            if (bl2) {
                plotLane = plotCommit.lane;
                plotLane = this.handleMerge(n2, plotCommit, plotCommit2, plotCommit3, plotLane);
                plotCommit3.addMergingLane(plotLane);
                continue;
            }
            plotLane = plotCommit3.lane;
            plotCommit.addForkingOffLane(plotLane);
        }
    }

    private PlotLane handleMerge(int n2, PlotCommit plotCommit, PlotCommit plotCommit2, PlotCommit plotCommit3, PlotLane plotLane) {
        int n3;
        int n4 = n2;
        BitSet bitSet = new BitSet();
        for (n3 = n2 - 1; n3 >= 0; --n3) {
            PlotCommit plotCommit4 = (PlotCommit)this.get(n3);
            if (plotCommit4 == plotCommit3) {
                n4 = n3;
                break;
            }
            PlotCommitList.addBlockedPosition(bitSet, plotCommit4);
        }
        if (bitSet.get(plotLane.getPosition())) {
            n3 = 0;
            if (plotCommit2 != null) {
                for (int i2 = n2 - 1; i2 > n4; --i2) {
                    PlotCommit plotCommit5 = (PlotCommit)this.get(i2);
                    if (plotCommit5 != plotCommit2) continue;
                    n3 = 1;
                    break;
                }
            }
            if (n3 != 0) {
                plotLane = this.nextFreeLane(bitSet);
                plotCommit.addForkingOffLane(plotLane);
                this.closeLane(plotLane);
            } else {
                int n5 = this.getFreePosition(bitSet);
                this.freePositions.add(plotLane.getPosition());
                plotLane.position = n5;
            }
        }
        this.drawLaneToChild(n2, plotCommit3, plotLane);
        return plotLane;
    }

    private void drawLaneToChild(int n2, PlotCommit plotCommit, PlotLane plotLane) {
        PlotCommit plotCommit2;
        for (int i2 = n2 - 1; i2 >= 0 && (plotCommit2 = (PlotCommit)this.get(i2)) != plotCommit; --i2) {
            if (plotCommit2 == null) continue;
            plotCommit2.addPassingLane(plotLane);
        }
    }

    private static void addBlockedPosition(BitSet bitSet, PlotCommit plotCommit) {
        if (plotCommit != null) {
            PlotLane plotLane = plotCommit.getLane();
            if (plotLane != null) {
                bitSet.set(plotLane.getPosition());
            }
            for (PlotLane plotLane2 : plotCommit.forkingOffLanes) {
                bitSet.set(plotLane2.getPosition());
            }
            for (PlotLane plotLane2 : plotCommit.mergingLanes) {
                bitSet.set(plotLane2.getPosition());
            }
        }
    }

    private void closeLane(PlotLane plotLane) {
        if (this.activeLanes.remove(plotLane)) {
            this.recycleLane(plotLane);
            this.laneLength.remove(plotLane);
            this.freePositions.add(plotLane.getPosition());
        }
    }

    private void setupChildren(PlotCommit plotCommit) {
        int n2 = plotCommit.getParentCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            ((PlotCommit)plotCommit.getParent(i2)).addChild(plotCommit);
        }
    }

    private PlotLane nextFreeLane() {
        return this.nextFreeLane(null);
    }

    private PlotLane nextFreeLane(BitSet bitSet) {
        PlotLane plotLane = this.createLane();
        plotLane.position = this.getFreePosition(bitSet);
        this.activeLanes.add(plotLane);
        this.laneLength.put(plotLane, 1);
        return plotLane;
    }

    private int getFreePosition(BitSet bitSet) {
        if (this.freePositions.isEmpty()) {
            return this.positionsAllocated++;
        }
        if (bitSet != null) {
            for (Integer n2 : this.freePositions) {
                if (bitSet.get(n2)) continue;
                this.freePositions.remove(n2);
                return n2;
            }
            return this.positionsAllocated++;
        }
        Integer n3 = (Integer)this.freePositions.first();
        this.freePositions.remove(n3);
        return n3;
    }

    protected PlotLane createLane() {
        return new PlotLane();
    }

    protected void recycleLane(PlotLane plotLane) {
    }
}

