/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revplot;

import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revplot.PlotLane;
import org.eclipse.jgit.revwalk.RevCommit;

public class PlotCommit
extends RevCommit {
    static final PlotCommit[] NO_CHILDREN = new PlotCommit[0];
    static final PlotLane[] NO_LANES = new PlotLane[0];
    static final Ref[] NO_REFS = new Ref[0];
    PlotLane[] forkingOffLanes = NO_LANES;
    PlotLane[] passingLanes = NO_LANES;
    PlotLane[] mergingLanes = NO_LANES;
    PlotLane lane;
    PlotCommit[] children = NO_CHILDREN;
    Ref[] refs = NO_REFS;

    protected PlotCommit(AnyObjectId anyObjectId) {
        super(anyObjectId);
    }

    void addForkingOffLane(PlotLane plotLane) {
        this.forkingOffLanes = PlotCommit.addLane(plotLane, this.forkingOffLanes);
    }

    void addPassingLane(PlotLane plotLane) {
        this.passingLanes = PlotCommit.addLane(plotLane, this.passingLanes);
    }

    void addMergingLane(PlotLane plotLane) {
        this.mergingLanes = PlotCommit.addLane(plotLane, this.mergingLanes);
    }

    private static PlotLane[] addLane(PlotLane plotLane, PlotLane[] plotLaneArray) {
        int n2 = plotLaneArray.length;
        switch (n2) {
            case 0: {
                plotLaneArray = new PlotLane[]{plotLane};
                break;
            }
            case 1: {
                plotLaneArray = new PlotLane[]{plotLaneArray[0], plotLane};
                break;
            }
            default: {
                PlotLane[] plotLaneArray2 = new PlotLane[n2 + 1];
                System.arraycopy(plotLaneArray, 0, plotLaneArray2, 0, n2);
                plotLaneArray2[n2] = plotLane;
                plotLaneArray = plotLaneArray2;
            }
        }
        return plotLaneArray;
    }

    void addChild(PlotCommit plotCommit) {
        int n2 = this.children.length;
        switch (n2) {
            case 0: {
                this.children = new PlotCommit[]{plotCommit};
                break;
            }
            case 1: {
                if (plotCommit.getId().equals(this.children[0].getId())) break;
                this.children = new PlotCommit[]{this.children[0], plotCommit};
                break;
            }
            default: {
                for (PlotCommit plotCommit2 : this.children) {
                    if (!plotCommit.getId().equals(plotCommit2.getId())) continue;
                    return;
                }
                PlotCommit[] plotCommitArray = new PlotCommit[n2 + 1];
                System.arraycopy(this.children, 0, plotCommitArray, 0, n2);
                plotCommitArray[n2] = plotCommit;
                this.children = plotCommitArray;
            }
        }
    }

    public final int getChildCount() {
        return this.children.length;
    }

    public final PlotCommit getChild(int n2) {
        return this.children[n2];
    }

    public final boolean isChild(PlotCommit plotCommit) {
        for (PlotCommit plotCommit2 : this.children) {
            if (plotCommit2 != plotCommit) continue;
            return true;
        }
        return false;
    }

    public final int getRefCount() {
        return this.refs.length;
    }

    public final Ref getRef(int n2) {
        return this.refs[n2];
    }

    public final PlotLane getLane() {
        return this.lane;
    }

    @Override
    public void reset() {
        this.forkingOffLanes = NO_LANES;
        this.passingLanes = NO_LANES;
        this.mergingLanes = NO_LANES;
        this.children = NO_CHILDREN;
        this.lane = null;
        super.reset();
    }
}

