/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revplot;

import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revplot.PlotCommit;
import org.eclipse.jgit.revplot.PlotLane;
import org.eclipse.jgit.revwalk.RevFlag;

public abstract class AbstractPlotRenderer {
    private static final int LANE_WIDTH = 14;
    private static final int LINE_WIDTH = 2;
    private static final int LEFT_PAD = 2;

    /*
     * WARNING - void declaration
     */
    protected void paintCommit(PlotCommit plotCommit, int n2) {
        void var11_18;
        int n3;
        int n4;
        Object object;
        PlotLane plotLane;
        PlotLane plotLane2;
        int n5;
        int n6 = AbstractPlotRenderer.computeDotSize(n2);
        PlotLane plotLane3 = plotCommit.getLane();
        int n7 = AbstractPlotRenderer.laneC(plotLane3);
        Object object2 = this.laneColor(plotLane3);
        int n8 = n7;
        for (PlotLane plotLaneArray2 : plotCommit.passingLanes) {
            n5 = AbstractPlotRenderer.laneC(plotLaneArray2);
            Object string = this.laneColor(plotLaneArray2);
            this.drawLine(string, n5, 0, n5, n2, 2);
            n8 = Math.max(n8, n5);
        }
        int n9 = n7 - n6 / 2 - 1;
        int n10 = (n2 - n6) / 2;
        int n11 = plotCommit.getParentCount();
        if (n11 > 0) {
            this.drawLine(object2, n7, n2, n7, (n2 + n6) / 2, 2);
            PlotLane[] n12 = plotCommit.mergingLanes;
            n5 = n12.length;
            for (int i2 = 0; i2 < n5; ++i2) {
                plotLane = plotLane2 = n12[i2];
                object = this.laneColor(plotLane);
                n4 = AbstractPlotRenderer.laneC(plotLane);
                if (Math.abs(n7 - n4) > 14) {
                    n3 = n7 < n4 ? n4 - 7 : n4 + 7;
                    this.drawLine(object, n7, n2 / 2, n3, n2 / 2, 2);
                    this.drawLine(object, n3, n2 / 2, n4, n2, 2);
                } else {
                    this.drawLine(object, n7, n2 / 2, n4, n2, 2);
                }
                n8 = Math.max(n8, n4);
            }
        }
        if (plotCommit.getChildCount() > 0) {
            PlotLane[] plotLaneArray = plotCommit.forkingOffLanes;
            n5 = plotLaneArray.length;
            for (int i3 = 0; i3 < n5; ++i3) {
                plotLane = plotLane2 = plotLaneArray[i3];
                object = this.laneColor(plotLane);
                n4 = AbstractPlotRenderer.laneC(plotLane);
                if (Math.abs(n7 - n4) > 14) {
                    n3 = n7 < n4 ? n4 - 7 : n4 + 7;
                    this.drawLine(object, n7, n2 / 2, n3, n2 / 2, 2);
                    this.drawLine(object, n3, n2 / 2, n4, 0, 2);
                } else {
                    this.drawLine(object, n7, n2 / 2, n4, 0, 2);
                }
                n8 = Math.max(n8, n4);
            }
            int n12 = plotCommit.getChildCount() - plotCommit.forkingOffLanes.length;
            if (n12 > 0) {
                this.drawLine(object2, n7, 0, n7, n10, 2);
            }
        }
        if (plotCommit.has(RevFlag.UNINTERESTING)) {
            this.drawBoundaryDot(n9, n10, n6, n6);
        } else {
            this.drawCommitDot(n9, n10, n6, n6);
        }
        int n13 = Math.max(n8 + 7, n9 + n6) + 8;
        n5 = plotCommit.refs.length;
        for (int i4 = 0; i4 < n5; ++i4) {
            var11_18 += this.drawLabel((int)(var11_18 + n6), n2 / 2, plotCommit.refs[i4]);
        }
        String string = plotCommit.getShortMessage();
        this.drawText(string, (int)(var11_18 + n6), n2);
    }

    protected abstract int drawLabel(int var1, int var2, Ref var3);

    private static int computeDotSize(int n2) {
        int n3 = (int)((float)Math.min(n2, 14) * 0.5f);
        n3 += n3 & 1;
        return n3;
    }

    protected abstract Object laneColor(PlotLane var1);

    protected abstract void drawLine(Object var1, int var2, int var3, int var4, int var5, int var6);

    protected abstract void drawCommitDot(int var1, int var2, int var3, int var4);

    protected abstract void drawBoundaryDot(int var1, int var2, int var3, int var4);

    protected abstract void drawText(String var1, int var2, int var3);

    private static int laneX(PlotLane plotLane) {
        int n2 = plotLane != null ? plotLane.getPosition() : 0;
        return 2 + 14 * n2;
    }

    private static int laneC(PlotLane plotLane) {
        return AbstractPlotRenderer.laneX(plotLane) + 7;
    }
}

