/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.patch;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.patch.BinaryHunk;
import org.eclipse.jgit.patch.CombinedFileHeader;
import org.eclipse.jgit.patch.FileHeader;
import org.eclipse.jgit.patch.FileHeader$PatchType;
import org.eclipse.jgit.patch.FormatError;
import org.eclipse.jgit.patch.FormatError$Severity;
import org.eclipse.jgit.patch.HunkHeader;
import org.eclipse.jgit.util.RawParseUtils;
import org.eclipse.jgit.util.TemporaryBuffer$Heap;

public class Patch {
    static final byte[] DIFF_GIT = Constants.encodeASCII("diff --git ");
    private static final byte[] DIFF_CC = Constants.encodeASCII("diff --cc ");
    private static final byte[] DIFF_COMBINED = Constants.encodeASCII("diff --combined ");
    private static final byte[][] BIN_HEADERS = new byte[][]{Constants.encodeASCII("Binary files "), Constants.encodeASCII("Files ")};
    private static final byte[] BIN_TRAILER = Constants.encodeASCII(" differ\n");
    private static final byte[] GIT_BINARY = Constants.encodeASCII("GIT binary patch\n");
    static final byte[] SIG_FOOTER = Constants.encodeASCII("-- \n");
    private final List files = new ArrayList();
    private final List errors = new ArrayList(0);

    public void addFile(FileHeader fileHeader) {
        this.files.add(fileHeader);
    }

    public List getFiles() {
        return this.files;
    }

    public void addError(FormatError formatError) {
        this.errors.add(formatError);
    }

    public List getErrors() {
        return this.errors;
    }

    public void parse(InputStream inputStream) {
        byte[] byArray = Patch.readFully(inputStream);
        this.parse(byArray, 0, byArray.length);
    }

    private static byte[] readFully(InputStream inputStream) {
        try (TemporaryBuffer$Heap temporaryBuffer$Heap = new TemporaryBuffer$Heap(Integer.MAX_VALUE);){
            temporaryBuffer$Heap.copy(inputStream);
            byte[] byArray = temporaryBuffer$Heap.toByteArray();
            return byArray;
        }
    }

    public void parse(byte[] byArray, int n2, int n3) {
        while (n2 < n3) {
            n2 = this.parseFile(byArray, n2, n3);
        }
    }

    private int parseFile(byte[] byArray, int n2, int n3) {
        while (n2 < n3) {
            if (FileHeader.isHunkHdr(byArray, n2, n3) >= 1) {
                this.error(byArray, n2, JGitText.get().hunkDisconnectedFromFile);
                n2 = RawParseUtils.nextLF(byArray, n2);
                continue;
            }
            if (RawParseUtils.match(byArray, n2, DIFF_GIT) >= 0) {
                return this.parseDiffGit(byArray, n2, n3);
            }
            if (RawParseUtils.match(byArray, n2, DIFF_CC) >= 0) {
                return this.parseDiffCombined(DIFF_CC, byArray, n2, n3);
            }
            if (RawParseUtils.match(byArray, n2, DIFF_COMBINED) >= 0) {
                return this.parseDiffCombined(DIFF_COMBINED, byArray, n2, n3);
            }
            int n4 = RawParseUtils.nextLF(byArray, n2);
            if (n4 >= n3) {
                return n3;
            }
            if (n4 - n2 < 6) {
                n2 = n4;
                continue;
            }
            if (RawParseUtils.match(byArray, n2, FileHeader.OLD_NAME) >= 0 && RawParseUtils.match(byArray, n4, FileHeader.NEW_NAME) >= 0) {
                int n5 = RawParseUtils.nextLF(byArray, n4);
                if (n5 >= n3) {
                    return n3;
                }
                if (FileHeader.isHunkHdr(byArray, n5, n3) == 1) {
                    return this.parseTraditionalPatch(byArray, n2, n3);
                }
            }
            n2 = n4;
        }
        return n2;
    }

    private int parseDiffGit(byte[] byArray, int n2, int n3) {
        FileHeader fileHeader = new FileHeader(byArray, n2);
        int n4 = fileHeader.parseGitFileName(n2 + DIFF_GIT.length, n3);
        if (n4 < 0) {
            return Patch.skipFile(byArray, n2);
        }
        n4 = fileHeader.parseGitHeaders(n4, n3);
        fileHeader.endOffset = n4 = this.parseHunks(fileHeader, n4, n3);
        this.addFile(fileHeader);
        return n4;
    }

    private int parseDiffCombined(byte[] byArray, byte[] byArray2, int n2, int n3) {
        CombinedFileHeader combinedFileHeader = new CombinedFileHeader(byArray2, n2);
        int n4 = combinedFileHeader.parseGitFileName(n2 + byArray.length, n3);
        if (n4 < 0) {
            return Patch.skipFile(byArray2, n2);
        }
        n4 = combinedFileHeader.parseGitHeaders(n4, n3);
        combinedFileHeader.endOffset = n4 = this.parseHunks(combinedFileHeader, n4, n3);
        this.addFile(combinedFileHeader);
        return n4;
    }

    private int parseTraditionalPatch(byte[] byArray, int n2, int n3) {
        FileHeader fileHeader = new FileHeader(byArray, n2);
        int n4 = fileHeader.parseTraditionalHeaders(n2, n3);
        fileHeader.endOffset = n4 = this.parseHunks(fileHeader, n4, n3);
        this.addFile(fileHeader);
        return n4;
    }

    private static int skipFile(byte[] byArray, int n2) {
        if (RawParseUtils.match(byArray, n2 = RawParseUtils.nextLF(byArray, n2), FileHeader.OLD_NAME) >= 0) {
            n2 = RawParseUtils.nextLF(byArray, n2);
        }
        return n2;
    }

    private int parseHunks(FileHeader fileHeader, int n2, int n3) {
        byte[] byArray = fileHeader.buf;
        block3: while (n2 < n3 && RawParseUtils.match(byArray, n2, DIFF_GIT) < 0 && RawParseUtils.match(byArray, n2, DIFF_CC) < 0 && RawParseUtils.match(byArray, n2, DIFF_COMBINED) < 0 && RawParseUtils.match(byArray, n2, FileHeader.OLD_NAME) < 0 && RawParseUtils.match(byArray, n2, FileHeader.NEW_NAME) < 0) {
            if (FileHeader.isHunkHdr(byArray, n2, n3) == fileHeader.getParentCount()) {
                HunkHeader hunkHeader = fileHeader.newHunkHeader(n2);
                hunkHeader.parseHeader();
                hunkHeader.endOffset = n2 = hunkHeader.parseBody(this, n3);
                fileHeader.addHunk(hunkHeader);
                if (n2 >= n3) continue;
                switch (byArray[n2]) {
                    case 10: 
                    case 64: 
                    case 100: {
                        continue block3;
                    }
                }
                if (RawParseUtils.match(byArray, n2, SIG_FOOTER) >= 0) continue;
                this.warn(byArray, n2, JGitText.get().unexpectedHunkTrailer);
                continue;
            }
            int n4 = RawParseUtils.nextLF(byArray, n2);
            if (fileHeader.getHunks().isEmpty() && RawParseUtils.match(byArray, n2, GIT_BINARY) >= 0) {
                fileHeader.patchType = FileHeader$PatchType.GIT_BINARY;
                return this.parseGitBinary(fileHeader, n4, n3);
            }
            if (fileHeader.getHunks().isEmpty() && BIN_TRAILER.length < n4 - n2 && RawParseUtils.match(byArray, n4 - BIN_TRAILER.length, BIN_TRAILER) >= 0 && Patch.matchAny(byArray, n2, BIN_HEADERS)) {
                fileHeader.patchType = FileHeader$PatchType.BINARY;
                return n4;
            }
            n2 = n4;
        }
        if (fileHeader.getHunks().isEmpty() && fileHeader.getPatchType() == FileHeader$PatchType.UNIFIED && !fileHeader.hasMetaDataChanges()) {
            fileHeader.patchType = FileHeader$PatchType.BINARY;
        }
        return n2;
    }

    private int parseGitBinary(FileHeader fileHeader, int n2, int n3) {
        BinaryHunk binaryHunk = new BinaryHunk(fileHeader, n2);
        int n4 = binaryHunk.parseHunk(n2, n3);
        if (n4 < 0) {
            this.error(fileHeader.buf, n2, JGitText.get().missingForwardImageInGITBinaryPatch);
            return n2;
        }
        binaryHunk.endOffset = n2 = n4;
        fileHeader.forwardBinaryHunk = binaryHunk;
        BinaryHunk binaryHunk2 = new BinaryHunk(fileHeader, n2);
        int n5 = binaryHunk2.parseHunk(n2, n3);
        if (n5 >= 0) {
            binaryHunk2.endOffset = n2 = n5;
            fileHeader.reverseBinaryHunk = binaryHunk2;
        }
        return n2;
    }

    void warn(byte[] byArray, int n2, String string) {
        this.addError(new FormatError(byArray, n2, FormatError$Severity.WARNING, string));
    }

    void error(byte[] byArray, int n2, String string) {
        this.addError(new FormatError(byArray, n2, FormatError$Severity.ERROR, string));
    }

    private static boolean matchAny(byte[] byArray, int n2, byte[][] byArray2) {
        for (byte[] byArray3 : byArray2) {
            if (RawParseUtils.match(byArray, n2, byArray3) < 0) continue;
            return true;
        }
        return false;
    }
}

