/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.patch;

import java.io.OutputStream;
import java.text.MessageFormat;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.diff.EditList;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.patch.FileHeader;
import org.eclipse.jgit.patch.HunkHeader$1;
import org.eclipse.jgit.patch.HunkHeader$OldImage;
import org.eclipse.jgit.patch.Patch;
import org.eclipse.jgit.util.MutableInteger;
import org.eclipse.jgit.util.RawParseUtils;

public class HunkHeader {
    final FileHeader file;
    final int startOffset;
    int endOffset;
    private final HunkHeader$OldImage old;
    int newStartLine;
    int newLineCount;
    int nContext;
    private EditList editList;

    HunkHeader(FileHeader fileHeader, int n2) {
        this(fileHeader, n2, new HunkHeader$1(fileHeader));
    }

    HunkHeader(FileHeader fileHeader, int n2, HunkHeader$OldImage hunkHeader$OldImage) {
        this.file = fileHeader;
        this.startOffset = n2;
        this.old = hunkHeader$OldImage;
    }

    HunkHeader(FileHeader fileHeader, EditList editList) {
        this(fileHeader, fileHeader.buf.length);
        this.editList = editList;
        this.endOffset = this.startOffset;
        this.nContext = 0;
        if (editList.isEmpty()) {
            this.newStartLine = 0;
            this.newLineCount = 0;
        } else {
            this.newStartLine = ((Edit)editList.get(0)).getBeginB();
            Edit edit = (Edit)editList.get(editList.size() - 1);
            this.newLineCount = edit.getEndB() - this.newStartLine;
        }
    }

    public FileHeader getFileHeader() {
        return this.file;
    }

    public byte[] getBuffer() {
        return this.file.buf;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public HunkHeader$OldImage getOldImage() {
        return this.old;
    }

    public int getNewStartLine() {
        return this.newStartLine;
    }

    public int getNewLineCount() {
        return this.newLineCount;
    }

    public int getLinesContext() {
        return this.nContext;
    }

    public EditList toEditList() {
        if (this.editList == null) {
            this.editList = new EditList();
            byte[] byArray = this.file.buf;
            int n2 = RawParseUtils.nextLF(byArray, this.startOffset);
            int n3 = this.old.startLine;
            int n4 = this.newStartLine;
            Edit edit = null;
            block6: while (n2 < this.endOffset) {
                switch (byArray[n2]) {
                    case 10: 
                    case 32: {
                        edit = null;
                        ++n3;
                        ++n4;
                        break;
                    }
                    case 45: {
                        if (edit == null) {
                            edit = new Edit(n3 - 1, n4 - 1);
                            this.editList.add(edit);
                        }
                        ++n3;
                        edit.extendA();
                        break;
                    }
                    case 43: {
                        if (edit == null) {
                            edit = new Edit(n3 - 1, n4 - 1);
                            this.editList.add(edit);
                        }
                        ++n4;
                        edit.extendB();
                        break;
                    }
                    case 92: {
                        break;
                    }
                    default: {
                        break block6;
                    }
                }
                n2 = RawParseUtils.nextLF(byArray, n2);
            }
        }
        return this.editList;
    }

    void parseHeader() {
        byte[] byArray = this.file.buf;
        MutableInteger mutableInteger = new MutableInteger();
        mutableInteger.value = RawParseUtils.nextLF(byArray, this.startOffset, ' ');
        this.old.startLine = -RawParseUtils.parseBase10(byArray, mutableInteger.value, mutableInteger);
        this.old.lineCount = byArray[mutableInteger.value] == 44 ? RawParseUtils.parseBase10(byArray, mutableInteger.value + 1, mutableInteger) : 1;
        this.newStartLine = RawParseUtils.parseBase10(byArray, mutableInteger.value + 1, mutableInteger);
        this.newLineCount = byArray[mutableInteger.value] == 44 ? RawParseUtils.parseBase10(byArray, mutableInteger.value + 1, mutableInteger) : 1;
    }

    int parseBody(Patch patch, int n2) {
        int n3;
        byte[] byArray = this.file.buf;
        int n4 = n3 = RawParseUtils.nextLF(byArray, this.startOffset);
        this.old.nDeleted = 0;
        this.old.nAdded = 0;
        block6: while (n3 < n2) {
            switch (byArray[n3]) {
                case 10: 
                case 32: {
                    ++this.nContext;
                    break;
                }
                case 45: {
                    ++this.old.nDeleted;
                    break;
                }
                case 43: {
                    ++this.old.nAdded;
                    break;
                }
                case 92: {
                    break;
                }
                default: {
                    break block6;
                }
            }
            n4 = n3;
            n3 = RawParseUtils.nextLF(byArray, n3);
        }
        if (n4 < n2 && this.nContext + this.old.nDeleted - 1 == this.old.lineCount && this.nContext + this.old.nAdded == this.newLineCount && RawParseUtils.match(byArray, n4, Patch.SIG_FOOTER) >= 0) {
            --this.old.nDeleted;
            return n4;
        }
        if (this.nContext + this.old.nDeleted < this.old.lineCount) {
            int n5 = this.old.lineCount - (this.nContext + this.old.nDeleted);
            patch.error(byArray, this.startOffset, MessageFormat.format(JGitText.get().truncatedHunkOldLinesMissing, n5));
        } else if (this.nContext + this.old.nAdded < this.newLineCount) {
            int n6 = this.newLineCount - (this.nContext + this.old.nAdded);
            patch.error(byArray, this.startOffset, MessageFormat.format(JGitText.get().truncatedHunkNewLinesMissing, n6));
        } else if (this.nContext + this.old.nDeleted > this.old.lineCount || this.nContext + this.old.nAdded > this.newLineCount) {
            String string = this.old.lineCount + ":" + this.newLineCount;
            String string2 = this.nContext + this.old.nDeleted + ":" + (this.nContext + this.old.nAdded);
            patch.warn(byArray, this.startOffset, MessageFormat.format(JGitText.get().hunkHeaderDoesNotMatchBodyLineCountOf, string, string2));
        }
        return n3;
    }

    void extractFileLines(OutputStream[] outputStreamArray) {
        byte[] byArray = this.file.buf;
        int n2 = this.startOffset;
        int n3 = RawParseUtils.nextLF(byArray, n2);
        if (this.endOffset <= n3) {
            return;
        }
        outputStreamArray[0].write(byArray, n2, n3 - n2);
        n2 = n3;
        block5: while (n2 < this.endOffset) {
            n3 = RawParseUtils.nextLF(byArray, n2);
            switch (byArray[n2]) {
                case 10: 
                case 32: 
                case 92: {
                    outputStreamArray[0].write(byArray, n2, n3 - n2);
                    outputStreamArray[1].write(byArray, n2, n3 - n2);
                    break;
                }
                case 45: {
                    outputStreamArray[0].write(byArray, n2, n3 - n2);
                    break;
                }
                case 43: {
                    outputStreamArray[1].write(byArray, n2, n3 - n2);
                    break;
                }
                default: {
                    break block5;
                }
            }
            n2 = n3;
        }
    }

    void extractFileLines(StringBuilder stringBuilder, String[] stringArray, int[] nArray) {
        byte[] byArray = this.file.buf;
        int n2 = this.startOffset;
        int n3 = RawParseUtils.nextLF(byArray, n2);
        if (this.endOffset <= n3) {
            return;
        }
        this.copyLine(stringBuilder, stringArray, nArray, 0);
        n2 = n3;
        block5: while (n2 < this.endOffset) {
            n3 = RawParseUtils.nextLF(byArray, n2);
            switch (byArray[n2]) {
                case 10: 
                case 32: 
                case 92: {
                    this.copyLine(stringBuilder, stringArray, nArray, 0);
                    this.skipLine(stringArray, nArray, 1);
                    break;
                }
                case 45: {
                    this.copyLine(stringBuilder, stringArray, nArray, 0);
                    break;
                }
                case 43: {
                    this.copyLine(stringBuilder, stringArray, nArray, 1);
                    break;
                }
                default: {
                    break block5;
                }
            }
            n2 = n3;
        }
    }

    void copyLine(StringBuilder stringBuilder, String[] stringArray, int[] nArray, int n2) {
        String string = stringArray[n2];
        int n3 = nArray[n2];
        int n4 = string.indexOf(10, n3);
        n4 = n4 < 0 ? string.length() : ++n4;
        stringBuilder.append(string, n3, n4);
        nArray[n2] = n4;
    }

    void skipLine(String[] stringArray, int[] nArray, int n2) {
        String string = stringArray[n2];
        int n3 = string.indexOf(10, nArray[n2]);
        nArray[n2] = n3 < 0 ? string.length() : n3 + 1;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("HunkHeader[");
        stringBuilder.append(this.getOldImage().getStartLine());
        stringBuilder.append(',');
        stringBuilder.append(this.getOldImage().getLineCount());
        stringBuilder.append("->");
        stringBuilder.append(this.getNewStartLine()).append(',').append(this.getNewLineCount());
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

