/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.patch;

import java.nio.charset.StandardCharsets;
import java.util.Locale;
import org.eclipse.jgit.patch.FormatError$Severity;
import org.eclipse.jgit.util.RawParseUtils;

public class FormatError {
    private final byte[] buf;
    private final int offset;
    private final FormatError$Severity severity;
    private final String message;

    FormatError(byte[] byArray, int n2, FormatError$Severity severity, String string) {
        this.buf = byArray;
        this.offset = n2;
        this.severity = severity;
        this.message = string;
    }

    public FormatError$Severity getSeverity() {
        return this.severity;
    }

    public String getMessage() {
        return this.message;
    }

    public byte[] getBuffer() {
        return this.buf;
    }

    public int getOffset() {
        return this.offset;
    }

    public String getLineText() {
        int n2 = RawParseUtils.nextLF(this.buf, this.offset);
        return RawParseUtils.decode(StandardCharsets.UTF_8, this.buf, this.offset, n2);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getSeverity().name().toLowerCase(Locale.ROOT));
        stringBuilder.append(": at offset ");
        stringBuilder.append(this.getOffset());
        stringBuilder.append(": ");
        stringBuilder.append(this.getMessage());
        stringBuilder.append("\n");
        stringBuilder.append("  in ");
        stringBuilder.append(this.getLineText());
        return stringBuilder.toString();
    }
}

