/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.patch;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffEntry$ChangeType;
import org.eclipse.jgit.diff.EditList;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.patch.BinaryHunk;
import org.eclipse.jgit.patch.FileHeader$PatchType;
import org.eclipse.jgit.patch.HunkHeader;
import org.eclipse.jgit.patch.Patch;
import org.eclipse.jgit.util.QuotedString;
import org.eclipse.jgit.util.RawParseUtils;
import org.eclipse.jgit.util.TemporaryBuffer;
import org.eclipse.jgit.util.TemporaryBuffer$Heap;

public class FileHeader
extends DiffEntry {
    private static final byte[] OLD_MODE = Constants.encodeASCII("old mode ");
    private static final byte[] NEW_MODE = Constants.encodeASCII("new mode ");
    static final byte[] DELETED_FILE_MODE = Constants.encodeASCII("deleted file mode ");
    static final byte[] NEW_FILE_MODE = Constants.encodeASCII("new file mode ");
    private static final byte[] COPY_FROM = Constants.encodeASCII("copy from ");
    private static final byte[] COPY_TO = Constants.encodeASCII("copy to ");
    private static final byte[] RENAME_OLD = Constants.encodeASCII("rename old ");
    private static final byte[] RENAME_NEW = Constants.encodeASCII("rename new ");
    private static final byte[] RENAME_FROM = Constants.encodeASCII("rename from ");
    private static final byte[] RENAME_TO = Constants.encodeASCII("rename to ");
    private static final byte[] SIMILARITY_INDEX = Constants.encodeASCII("similarity index ");
    private static final byte[] DISSIMILARITY_INDEX = Constants.encodeASCII("dissimilarity index ");
    static final byte[] INDEX = Constants.encodeASCII("index ");
    static final byte[] OLD_NAME = Constants.encodeASCII("--- ");
    static final byte[] NEW_NAME = Constants.encodeASCII("+++ ");
    final byte[] buf;
    final int startOffset;
    int endOffset;
    FileHeader$PatchType patchType;
    private List hunks;
    BinaryHunk forwardBinaryHunk;
    BinaryHunk reverseBinaryHunk;

    public FileHeader(byte[] byArray, EditList editList, FileHeader$PatchType fileHeader$PatchType) {
        this(byArray, 0);
        this.endOffset = byArray.length;
        int n2 = this.parseGitFileName(Patch.DIFF_GIT.length, byArray.length);
        this.parseGitHeaders(n2, byArray.length);
        this.patchType = fileHeader$PatchType;
        this.addHunk(new HunkHeader(this, editList));
    }

    FileHeader(byte[] byArray, int n2) {
        this.buf = byArray;
        this.startOffset = n2;
        this.changeType = DiffEntry$ChangeType.MODIFY;
        this.patchType = FileHeader$PatchType.UNIFIED;
    }

    int getParentCount() {
        return 1;
    }

    public byte[] getBuffer() {
        return this.buf;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public String getScriptText() {
        return this.getScriptText(null, null);
    }

    public String getScriptText(Charset charset, Charset charset2) {
        return this.getScriptText(new Charset[]{charset, charset2});
    }

    String getScriptText(Charset[] charsetArray) {
        Comparable<Charset> comparable;
        if (this.getHunks().isEmpty()) {
            return RawParseUtils.extractBinaryString(this.buf, this.startOffset, this.endOffset);
        }
        if (charsetArray != null && charsetArray.length != this.getParentCount() + 1) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().expectedCharacterEncodingGuesses, this.getParentCount() + 1));
        }
        if (FileHeader.trySimpleConversion(charsetArray)) {
            Comparable<Charset> comparable2 = comparable = charsetArray != null ? charsetArray[0] : null;
            if (comparable == null) {
                comparable = StandardCharsets.UTF_8;
            }
            try {
                return RawParseUtils.decodeNoFallback((Charset)comparable, this.buf, this.startOffset, this.endOffset);
            }
            catch (CharacterCodingException characterCodingException) {
                // empty catch block
            }
        }
        comparable = new StringBuilder(this.endOffset - this.startOffset);
        int n2 = ((HunkHeader)this.getHunks().get(0)).getStartOffset();
        int n3 = this.startOffset;
        while (n3 < n2) {
            int n4 = Math.min(n2, RawParseUtils.nextLF(this.buf, n3));
            ((StringBuilder)comparable).append(RawParseUtils.extractBinaryString(this.buf, n3, n4));
            n3 = n4;
        }
        String[] stringArray = this.extractFileLines(charsetArray);
        int[] nArray = new int[stringArray.length];
        for (HunkHeader hunkHeader : this.getHunks()) {
            hunkHeader.extractFileLines((StringBuilder)comparable, stringArray, nArray);
        }
        return ((StringBuilder)comparable).toString();
    }

    private static boolean trySimpleConversion(Charset[] charsetArray) {
        if (charsetArray == null) {
            return true;
        }
        for (int i2 = 1; i2 < charsetArray.length; ++i2) {
            if (charsetArray[i2] == charsetArray[0]) continue;
            return false;
        }
        return true;
    }

    private String[] extractFileLines(Charset[] charsetArray) {
        OutputStream[] outputStreamArray = new TemporaryBuffer[this.getParentCount() + 1];
        try {
            for (int i2 = 0; i2 < outputStreamArray.length; ++i2) {
                outputStreamArray[i2] = new TemporaryBuffer$Heap(Integer.MAX_VALUE);
            }
            for (HunkHeader hunkHeader : this.getHunks()) {
                hunkHeader.extractFileLines(outputStreamArray);
            }
            String[] stringArray = new String[outputStreamArray.length];
            for (int i3 = 0; i3 < outputStreamArray.length; ++i3) {
                Charset charset;
                Charset charset2 = charset = charsetArray != null ? charsetArray[i3] : null;
                if (charset == null) {
                    charset = StandardCharsets.UTF_8;
                }
                stringArray[i3] = RawParseUtils.decode(charset, ((TemporaryBuffer)outputStreamArray[i3]).toByteArray());
            }
            return stringArray;
        }
        catch (IOException iOException) {
            throw new RuntimeException(JGitText.get().cannotConvertScriptToText, iOException);
        }
    }

    public FileHeader$PatchType getPatchType() {
        return this.patchType;
    }

    public boolean hasMetaDataChanges() {
        return this.changeType != DiffEntry$ChangeType.MODIFY || this.newMode != this.oldMode;
    }

    public List getHunks() {
        if (this.hunks == null) {
            return Collections.emptyList();
        }
        return this.hunks;
    }

    void addHunk(HunkHeader hunkHeader) {
        if (hunkHeader.getFileHeader() != this) {
            throw new IllegalArgumentException(JGitText.get().hunkBelongsToAnotherFile);
        }
        if (this.hunks == null) {
            this.hunks = new ArrayList();
        }
        this.hunks.add(hunkHeader);
    }

    HunkHeader newHunkHeader(int n2) {
        return new HunkHeader(this, n2);
    }

    public BinaryHunk getForwardBinaryHunk() {
        return this.forwardBinaryHunk;
    }

    public BinaryHunk getReverseBinaryHunk() {
        return this.reverseBinaryHunk;
    }

    public EditList toEditList() {
        EditList editList = new EditList();
        for (HunkHeader hunkHeader : this.hunks) {
            editList.addAll(hunkHeader.toEditList());
        }
        return editList;
    }

    int parseGitFileName(int n2, int n3) {
        int n4 = RawParseUtils.nextLF(this.buf, n2);
        int n5 = n2;
        if (n4 >= n3) {
            return -1;
        }
        int n6 = RawParseUtils.nextLF(this.buf, n2, '/');
        if (n6 >= n4) {
            return n4;
        }
        while (n2 < n4) {
            int n7 = RawParseUtils.nextLF(this.buf, n2, ' ');
            if (n7 >= n4) {
                return n4;
            }
            int n8 = RawParseUtils.nextLF(this.buf, n7, '/');
            if (n8 >= n4) {
                return n4;
            }
            if (this.eq(n6, n7 - 1, n8, n4 - 1)) {
                if (this.buf[n5] == 34) {
                    if (this.buf[n7 - 2] != 34) {
                        return n4;
                    }
                    this.oldPath = QuotedString.GIT_PATH.dequote(this.buf, n5, n7 - 1);
                    this.oldPath = FileHeader.p1(this.oldPath);
                } else {
                    this.oldPath = RawParseUtils.decode(StandardCharsets.UTF_8, this.buf, n6, n7 - 1);
                }
                this.newPath = this.oldPath;
                return n4;
            }
            n2 = n7;
        }
        return n4;
    }

    int parseGitHeaders(int n2, int n3) {
        int n4;
        while (n2 < n3 && FileHeader.isHunkHdr(this.buf, n2, n4 = RawParseUtils.nextLF(this.buf, n2)) < 1) {
            if (RawParseUtils.match(this.buf, n2, OLD_NAME) >= 0) {
                this.parseOldName(n2, n4);
            } else if (RawParseUtils.match(this.buf, n2, NEW_NAME) >= 0) {
                this.parseNewName(n2, n4);
            } else if (RawParseUtils.match(this.buf, n2, OLD_MODE) >= 0) {
                this.oldMode = this.parseFileMode(n2 + OLD_MODE.length, n4);
            } else if (RawParseUtils.match(this.buf, n2, NEW_MODE) >= 0) {
                this.newMode = this.parseFileMode(n2 + NEW_MODE.length, n4);
            } else if (RawParseUtils.match(this.buf, n2, DELETED_FILE_MODE) >= 0) {
                this.oldMode = this.parseFileMode(n2 + DELETED_FILE_MODE.length, n4);
                this.newMode = FileMode.MISSING;
                this.changeType = DiffEntry$ChangeType.DELETE;
            } else if (RawParseUtils.match(this.buf, n2, NEW_FILE_MODE) >= 0) {
                this.parseNewFileMode(n2, n4);
            } else if (RawParseUtils.match(this.buf, n2, COPY_FROM) >= 0) {
                this.oldPath = this.parseName(this.oldPath, n2 + COPY_FROM.length, n4);
                this.changeType = DiffEntry$ChangeType.COPY;
            } else if (RawParseUtils.match(this.buf, n2, COPY_TO) >= 0) {
                this.newPath = this.parseName(this.newPath, n2 + COPY_TO.length, n4);
                this.changeType = DiffEntry$ChangeType.COPY;
            } else if (RawParseUtils.match(this.buf, n2, RENAME_OLD) >= 0) {
                this.oldPath = this.parseName(this.oldPath, n2 + RENAME_OLD.length, n4);
                this.changeType = DiffEntry$ChangeType.RENAME;
            } else if (RawParseUtils.match(this.buf, n2, RENAME_NEW) >= 0) {
                this.newPath = this.parseName(this.newPath, n2 + RENAME_NEW.length, n4);
                this.changeType = DiffEntry$ChangeType.RENAME;
            } else if (RawParseUtils.match(this.buf, n2, RENAME_FROM) >= 0) {
                this.oldPath = this.parseName(this.oldPath, n2 + RENAME_FROM.length, n4);
                this.changeType = DiffEntry$ChangeType.RENAME;
            } else if (RawParseUtils.match(this.buf, n2, RENAME_TO) >= 0) {
                this.newPath = this.parseName(this.newPath, n2 + RENAME_TO.length, n4);
                this.changeType = DiffEntry$ChangeType.RENAME;
            } else if (RawParseUtils.match(this.buf, n2, SIMILARITY_INDEX) >= 0) {
                this.score = RawParseUtils.parseBase10(this.buf, n2 + SIMILARITY_INDEX.length, null);
            } else if (RawParseUtils.match(this.buf, n2, DISSIMILARITY_INDEX) >= 0) {
                this.score = RawParseUtils.parseBase10(this.buf, n2 + DISSIMILARITY_INDEX.length, null);
            } else {
                if (RawParseUtils.match(this.buf, n2, INDEX) < 0) break;
                this.parseIndexLine(n2 + INDEX.length, n4);
            }
            n2 = n4;
        }
        return n2;
    }

    void parseOldName(int n2, int n3) {
        this.oldPath = FileHeader.p1(this.parseName(this.oldPath, n2 + OLD_NAME.length, n3));
        if (this.oldPath == "/dev/null") {
            this.changeType = DiffEntry$ChangeType.ADD;
        }
    }

    void parseNewName(int n2, int n3) {
        this.newPath = FileHeader.p1(this.parseName(this.newPath, n2 + NEW_NAME.length, n3));
        if (this.newPath == "/dev/null") {
            this.changeType = DiffEntry$ChangeType.DELETE;
        }
    }

    void parseNewFileMode(int n2, int n3) {
        this.oldMode = FileMode.MISSING;
        this.newMode = this.parseFileMode(n2 + NEW_FILE_MODE.length, n3);
        this.changeType = DiffEntry$ChangeType.ADD;
    }

    int parseTraditionalHeaders(int n2, int n3) {
        int n4;
        while (n2 < n3 && FileHeader.isHunkHdr(this.buf, n2, n4 = RawParseUtils.nextLF(this.buf, n2)) < 1) {
            if (RawParseUtils.match(this.buf, n2, OLD_NAME) >= 0) {
                this.parseOldName(n2, n4);
            } else {
                if (RawParseUtils.match(this.buf, n2, NEW_NAME) < 0) break;
                this.parseNewName(n2, n4);
            }
            n2 = n4;
        }
        return n2;
    }

    private String parseName(String string, int n2, int n3) {
        String string2;
        if (n2 == n3) {
            return string;
        }
        if (this.buf[n2] == 34) {
            string2 = QuotedString.GIT_PATH.dequote(this.buf, n2, n3 - 1);
        } else {
            int n4;
            for (n4 = n3; n2 < n4 && this.buf[n4 - 1] != 9; --n4) {
            }
            if (n2 == n4) {
                n4 = n3;
            }
            string2 = RawParseUtils.decode(StandardCharsets.UTF_8, this.buf, n2, n4 - 1);
        }
        if (string2.equals("/dev/null")) {
            string2 = "/dev/null";
        }
        return string2;
    }

    private static String p1(String string) {
        int n2 = string.indexOf(47);
        return n2 > 0 ? string.substring(n2 + 1) : string;
    }

    FileMode parseFileMode(int n2, int n3) {
        int n4 = 0;
        while (n2 < n3 - 1) {
            n4 <<= 3;
            n4 += this.buf[n2++] - 48;
        }
        return FileMode.fromBits(n4);
    }

    void parseIndexLine(int n2, int n3) {
        int n4 = RawParseUtils.nextLF(this.buf, n2, '.');
        int n5 = RawParseUtils.nextLF(this.buf, n4, ' ');
        this.oldId = AbbreviatedObjectId.fromString(this.buf, n2, n4 - 1);
        this.newId = AbbreviatedObjectId.fromString(this.buf, n4 + 1, n5 - 1);
        if (n5 < n3) {
            this.newMode = this.oldMode = this.parseFileMode(n5, n3);
        }
    }

    private boolean eq(int n2, int n3, int n4, int n5) {
        if (n3 - n2 != n5 - n4) {
            return false;
        }
        while (n2 < n3) {
            if (this.buf[n2++] == this.buf[n4++]) continue;
            return false;
        }
        return true;
    }

    static int isHunkHdr(byte[] byArray, int n2, int n3) {
        int n4;
        for (n4 = n2; n4 < n3 && byArray[n4] == 64; ++n4) {
        }
        if (n4 - n2 < 2) {
            return 0;
        }
        if (n4 == n3 || byArray[n4++] != 32) {
            return 0;
        }
        if (n4 == n3 || byArray[n4++] != 45) {
            return 0;
        }
        return n4 - 3 - n2;
    }
}

