/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.patch;

import java.io.OutputStream;
import java.text.MessageFormat;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.patch.CombinedFileHeader;
import org.eclipse.jgit.patch.CombinedHunkHeader$1;
import org.eclipse.jgit.patch.CombinedHunkHeader$CombinedOldImage;
import org.eclipse.jgit.patch.HunkHeader;
import org.eclipse.jgit.patch.HunkHeader$OldImage;
import org.eclipse.jgit.patch.Patch;
import org.eclipse.jgit.util.MutableInteger;
import org.eclipse.jgit.util.RawParseUtils;

public class CombinedHunkHeader
extends HunkHeader {
    private CombinedHunkHeader$CombinedOldImage[] old;

    CombinedHunkHeader(CombinedFileHeader combinedFileHeader, int n2) {
        super(combinedFileHeader, n2, null);
        this.old = new CombinedHunkHeader$CombinedOldImage[combinedFileHeader.getParentCount()];
        for (int i2 = 0; i2 < this.old.length; ++i2) {
            int n3 = i2;
            this.old[i2] = new CombinedHunkHeader$1(this, combinedFileHeader, n3);
        }
    }

    @Override
    public CombinedFileHeader getFileHeader() {
        return (CombinedFileHeader)super.getFileHeader();
    }

    @Override
    public HunkHeader$OldImage getOldImage() {
        return this.getOldImage(0);
    }

    public HunkHeader$OldImage getOldImage(int n2) {
        return this.old[n2];
    }

    @Override
    void parseHeader() {
        byte[] byArray = this.file.buf;
        MutableInteger mutableInteger = new MutableInteger();
        mutableInteger.value = RawParseUtils.nextLF(byArray, this.startOffset, ' ');
        for (CombinedHunkHeader$CombinedOldImage combinedHunkHeader$CombinedOldImage : this.old) {
            combinedHunkHeader$CombinedOldImage.startLine = -RawParseUtils.parseBase10(byArray, mutableInteger.value, mutableInteger);
            combinedHunkHeader$CombinedOldImage.lineCount = byArray[mutableInteger.value] == 44 ? RawParseUtils.parseBase10(byArray, mutableInteger.value + 1, mutableInteger) : 1;
        }
        this.newStartLine = RawParseUtils.parseBase10(byArray, mutableInteger.value + 1, mutableInteger);
        this.newLineCount = byArray[mutableInteger.value] == 44 ? RawParseUtils.parseBase10(byArray, mutableInteger.value + 1, mutableInteger) : 1;
    }

    @Override
    int parseBody(Patch patch, int n2) {
        int n3;
        byte[] byArray = this.file.buf;
        int n4 = RawParseUtils.nextLF(byArray, this.startOffset);
        CombinedHunkHeader$CombinedOldImage[] combinedHunkHeader$CombinedOldImageArray = this.old;
        int n5 = combinedHunkHeader$CombinedOldImageArray.length;
        for (n3 = 0; n3 < n5; ++n3) {
            CombinedHunkHeader$CombinedOldImage combinedHunkHeader$CombinedOldImage = combinedHunkHeader$CombinedOldImageArray[n3];
            combinedHunkHeader$CombinedOldImage.nDeleted = 0;
            combinedHunkHeader$CombinedOldImage.nAdded = 0;
            combinedHunkHeader$CombinedOldImage.nContext = 0;
        }
        this.nContext = 0;
        int n6 = 0;
        block9: while (n4 < n2 && (n5 = RawParseUtils.nextLF(byArray, n4)) - n4 >= this.old.length + 1) {
            switch (byArray[n4]) {
                case 32: 
                case 43: 
                case 45: {
                    break;
                }
                default: {
                    break block9;
                }
            }
            n3 = 0;
            block10: for (int i2 = 0; i2 < this.old.length; ++i2) {
                switch (byArray[n4 + i2]) {
                    case 32: {
                        ++n3;
                        ++this.old[i2].nContext;
                        continue block10;
                    }
                    case 45: {
                        ++this.old[i2].nDeleted;
                        continue block10;
                    }
                    case 43: {
                        ++this.old[i2].nAdded;
                        ++n6;
                        continue block10;
                    }
                    default: {
                        break block9;
                    }
                }
            }
            if (n3 == this.old.length) {
                ++this.nContext;
            }
            n4 = n5;
        }
        for (n5 = 0; n5 < this.old.length; ++n5) {
            CombinedHunkHeader$CombinedOldImage combinedHunkHeader$CombinedOldImage = this.old[n5];
            int n7 = combinedHunkHeader$CombinedOldImage.nContext + combinedHunkHeader$CombinedOldImage.nDeleted;
            if (n7 >= combinedHunkHeader$CombinedOldImage.lineCount) continue;
            int n8 = combinedHunkHeader$CombinedOldImage.lineCount - n7;
            patch.error(byArray, this.startOffset, MessageFormat.format(JGitText.get().truncatedHunkLinesMissingForAncestor, n8, n5 + 1));
        }
        if (this.nContext + n6 < this.newLineCount) {
            n5 = this.newLineCount - (this.nContext + n6);
            patch.error(byArray, this.startOffset, MessageFormat.format(JGitText.get().truncatedHunkNewLinesMissing, n5));
        }
        return n4;
    }

    @Override
    void extractFileLines(OutputStream[] outputStreamArray) {
        byte[] byArray = this.file.buf;
        int n2 = this.startOffset;
        int n3 = RawParseUtils.nextLF(byArray, n2);
        if (this.endOffset <= n3) {
            return;
        }
        outputStreamArray[0].write(byArray, n2, n3 - n2);
        n2 = n3;
        block8: while (n2 < this.endOffset && (n3 = RawParseUtils.nextLF(byArray, n2)) - n2 >= this.old.length + 1) {
            switch (byArray[n2]) {
                case 32: 
                case 43: 
                case 45: {
                    break;
                }
                default: {
                    break block8;
                }
            }
            int n4 = 0;
            block9: for (int i2 = 0; i2 < this.old.length; ++i2) {
                switch (byArray[n2 + i2]) {
                    case 45: {
                        ++n4;
                        outputStreamArray[i2].write(byArray, n2, n3 - n2);
                        continue block9;
                    }
                    case 32: {
                        outputStreamArray[i2].write(byArray, n2, n3 - n2);
                        continue block9;
                    }
                    case 43: {
                        continue block9;
                    }
                    default: {
                        break block8;
                    }
                }
            }
            if (n4 < this.old.length) {
                outputStreamArray[this.old.length].write(byArray, n2, n3 - n2);
            }
            n2 = n3;
        }
    }

    @Override
    void extractFileLines(StringBuilder stringBuilder, String[] stringArray, int[] nArray) {
        byte[] byArray = this.file.buf;
        int n2 = this.startOffset;
        int n3 = RawParseUtils.nextLF(byArray, n2);
        if (this.endOffset <= n3) {
            return;
        }
        this.copyLine(stringBuilder, stringArray, nArray, 0);
        n2 = n3;
        block7: while (n2 < this.endOffset && (n3 = RawParseUtils.nextLF(byArray, n2)) - n2 >= this.old.length + 1) {
            switch (byArray[n2]) {
                case 32: 
                case 43: 
                case 45: {
                    break;
                }
                default: {
                    break block7;
                }
            }
            boolean bl2 = false;
            block8: for (int i2 = 0; i2 < this.old.length; ++i2) {
                switch (byArray[n2 + i2]) {
                    case 32: 
                    case 45: {
                        if (bl2) {
                            this.skipLine(stringArray, nArray, i2);
                            continue block8;
                        }
                        this.copyLine(stringBuilder, stringArray, nArray, i2);
                        bl2 = true;
                        continue block8;
                    }
                    case 43: {
                        continue block8;
                    }
                    default: {
                        break block7;
                    }
                }
            }
            if (!bl2) {
                this.copyLine(stringBuilder, stringArray, nArray, this.old.length);
            }
            n2 = n3;
        }
    }
}

