/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.patch;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jgit.diff.DiffEntry$ChangeType;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.patch.CombinedHunkHeader;
import org.eclipse.jgit.patch.FileHeader;
import org.eclipse.jgit.patch.HunkHeader;
import org.eclipse.jgit.util.RawParseUtils;

public class CombinedFileHeader
extends FileHeader {
    private static final byte[] MODE = Constants.encodeASCII("mode ");
    private AbbreviatedObjectId[] oldIds;
    private FileMode[] oldModes;

    CombinedFileHeader(byte[] byArray, int n2) {
        super(byArray, n2);
    }

    @Override
    public List getHunks() {
        return super.getHunks();
    }

    @Override
    public int getParentCount() {
        return this.oldIds.length;
    }

    @Override
    public FileMode getOldMode() {
        return this.getOldMode(0);
    }

    public FileMode getOldMode(int n2) {
        return this.oldModes[n2];
    }

    @Override
    public AbbreviatedObjectId getOldId() {
        return this.getOldId(0);
    }

    public AbbreviatedObjectId getOldId(int n2) {
        return this.oldIds[n2];
    }

    @Override
    public String getScriptText(Charset charset, Charset charset2) {
        Object[] objectArray = new Charset[this.getParentCount() + 1];
        Arrays.fill(objectArray, charset);
        objectArray[this.getParentCount()] = charset2;
        return this.getScriptText((Charset[])objectArray);
    }

    @Override
    public String getScriptText(Charset[] charsetArray) {
        return super.getScriptText(charsetArray);
    }

    @Override
    int parseGitHeaders(int n2, int n3) {
        while (n2 < n3) {
            int n4 = RawParseUtils.nextLF(this.buf, n2);
            if (CombinedFileHeader.isHunkHdr(this.buf, n2, n3) >= 1) break;
            if (RawParseUtils.match(this.buf, n2, OLD_NAME) >= 0) {
                this.parseOldName(n2, n4);
            } else if (RawParseUtils.match(this.buf, n2, NEW_NAME) >= 0) {
                this.parseNewName(n2, n4);
            } else if (RawParseUtils.match(this.buf, n2, INDEX) >= 0) {
                this.parseIndexLine(n2 + INDEX.length, n4);
            } else if (RawParseUtils.match(this.buf, n2, MODE) >= 0) {
                this.parseModeLine(n2 + MODE.length, n4);
            } else if (RawParseUtils.match(this.buf, n2, NEW_FILE_MODE) >= 0) {
                this.parseNewFileMode(n2, n4);
            } else {
                if (RawParseUtils.match(this.buf, n2, DELETED_FILE_MODE) < 0) break;
                this.parseDeletedFileMode(n2 + DELETED_FILE_MODE.length, n4);
            }
            n2 = n4;
        }
        return n2;
    }

    @Override
    protected void parseIndexLine(int n2, int n3) {
        int n4;
        ArrayList<AbbreviatedObjectId> arrayList = new ArrayList<AbbreviatedObjectId>();
        while (n2 < n3 && n3 > (n4 = RawParseUtils.nextLF(this.buf, n2, ','))) {
            arrayList.add(AbbreviatedObjectId.fromString(this.buf, n2, n4 - 1));
            n2 = n4;
        }
        this.oldIds = new AbbreviatedObjectId[arrayList.size() + 1];
        arrayList.toArray(this.oldIds);
        n4 = RawParseUtils.nextLF(this.buf, n2, '.');
        this.oldIds[arrayList.size()] = AbbreviatedObjectId.fromString(this.buf, n2, n4 - 1);
        this.newId = AbbreviatedObjectId.fromString(this.buf, n4 + 1, n3 - 1);
        this.oldModes = new FileMode[this.oldIds.length];
    }

    @Override
    protected void parseNewFileMode(int n2, int n3) {
        for (int i2 = 0; i2 < this.oldModes.length; ++i2) {
            this.oldModes[i2] = FileMode.MISSING;
        }
        super.parseNewFileMode(n2, n3);
    }

    @Override
    HunkHeader newHunkHeader(int n2) {
        return new CombinedHunkHeader(this, n2);
    }

    private void parseModeLine(int n2, int n3) {
        int n4;
        int n5 = 0;
        while (n2 < n3 && n3 > (n4 = RawParseUtils.nextLF(this.buf, n2, ','))) {
            this.oldModes[n5++] = this.parseFileMode(n2, n4);
            n2 = n4;
        }
        n4 = RawParseUtils.nextLF(this.buf, n2, '.');
        this.oldModes[n5] = this.parseFileMode(n2, n4);
        this.newMode = this.parseFileMode(n4 + 1, n3);
    }

    private void parseDeletedFileMode(int n2, int n3) {
        int n4;
        this.changeType = DiffEntry$ChangeType.DELETE;
        int n5 = 0;
        while (n2 < n3 && n3 > (n4 = RawParseUtils.nextLF(this.buf, n2, ','))) {
            this.oldModes[n5++] = this.parseFileMode(n2, n4);
            n2 = n4;
        }
        this.oldModes[n5] = this.parseFileMode(n2, n3);
        this.newMode = FileMode.MISSING;
    }
}

