/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.patch;

import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.patch.BinaryHunk$Type;
import org.eclipse.jgit.patch.FileHeader;
import org.eclipse.jgit.util.RawParseUtils;

public class BinaryHunk {
    private static final byte[] LITERAL = Constants.encodeASCII("literal ");
    private static final byte[] DELTA = Constants.encodeASCII("delta ");
    private final FileHeader file;
    final int startOffset;
    int endOffset;
    private BinaryHunk$Type type;
    private int length;

    BinaryHunk(FileHeader fileHeader, int n2) {
        this.file = fileHeader;
        this.startOffset = n2;
    }

    public FileHeader getFileHeader() {
        return this.file;
    }

    public byte[] getBuffer() {
        return this.file.buf;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public BinaryHunk$Type getType() {
        return this.type;
    }

    public int getSize() {
        return this.length;
    }

    int parseHunk(int n2, int n3) {
        byte[] byArray = this.file.buf;
        if (RawParseUtils.match(byArray, n2, LITERAL) >= 0) {
            this.type = BinaryHunk$Type.LITERAL_DEFLATED;
            this.length = RawParseUtils.parseBase10(byArray, n2 + LITERAL.length, null);
        } else if (RawParseUtils.match(byArray, n2, DELTA) >= 0) {
            this.type = BinaryHunk$Type.DELTA_DEFLATED;
            this.length = RawParseUtils.parseBase10(byArray, n2 + DELTA.length, null);
        } else {
            return -1;
        }
        n2 = RawParseUtils.nextLF(byArray, n2);
        while (n2 < n3) {
            boolean bl2 = byArray[n2] == 10;
            n2 = RawParseUtils.nextLF(byArray, n2);
            if (!bl2) continue;
            break;
        }
        return n2;
    }
}

