/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.notes;

import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.notes.FanoutBucket;
import org.eclipse.jgit.notes.InMemoryNoteBucket;
import org.eclipse.jgit.notes.LeafBucket;
import org.eclipse.jgit.notes.NonNoteEntry;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.util.RawParseUtils;

final class NoteParser
extends CanonicalTreeParser {
    private final int prefixLen;
    private final int pathPadding;
    private NonNoteEntry firstNonNote;
    private NonNoteEntry lastNonNote;

    static InMemoryNoteBucket parse(AbbreviatedObjectId abbreviatedObjectId, ObjectId objectId, ObjectReader objectReader) {
        return new NoteParser(abbreviatedObjectId, objectReader, objectId).parse();
    }

    private NoteParser(AbbreviatedObjectId abbreviatedObjectId, ObjectReader objectReader, ObjectId objectId) {
        super(Constants.encodeASCII(abbreviatedObjectId.name()), objectReader, objectId);
        this.prefixLen = abbreviatedObjectId.length();
        int n2 = this.pathPadding = 0 < this.prefixLen ? 1 : 0;
        if (0 < this.pathPadding) {
            System.arraycopy(this.path, 0, this.path, this.pathPadding, this.prefixLen);
        }
    }

    private InMemoryNoteBucket parse() {
        InMemoryNoteBucket inMemoryNoteBucket = this.parseTree();
        inMemoryNoteBucket.nonNotes = this.firstNonNote;
        return inMemoryNoteBucket;
    }

    private InMemoryNoteBucket parseTree() {
        while (!this.eof()) {
            if (this.pathLen == this.pathPadding + 40 && this.isHex()) {
                return this.parseLeafTree();
            }
            if (this.getNameLength() == 2 && this.isHex() && this.isTree()) {
                return this.parseFanoutTree();
            }
            this.storeNonNote();
            this.next(1);
        }
        return new LeafBucket(this.prefixLen);
    }

    private LeafBucket parseLeafTree() {
        LeafBucket leafBucket = new LeafBucket(this.prefixLen);
        MutableObjectId mutableObjectId = new MutableObjectId();
        while (!this.eof()) {
            if (this.parseObjectId(mutableObjectId)) {
                leafBucket.parseOneEntry(mutableObjectId, this.getEntryObjectId());
            } else {
                this.storeNonNote();
            }
            this.next(1);
        }
        return leafBucket;
    }

    private boolean parseObjectId(MutableObjectId mutableObjectId) {
        if (this.pathLen == this.pathPadding + 40) {
            try {
                mutableObjectId.fromString(this.path, this.pathPadding);
                return true;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return false;
            }
        }
        return false;
    }

    private FanoutBucket parseFanoutTree() {
        FanoutBucket fanoutBucket = new FanoutBucket(this.prefixLen);
        while (!this.eof()) {
            int n2 = this.parseFanoutCell();
            if (0 <= n2) {
                fanoutBucket.setBucket(n2, this.getEntryObjectId());
            } else {
                this.storeNonNote();
            }
            this.next(1);
        }
        return fanoutBucket;
    }

    private int parseFanoutCell() {
        if (this.getNameLength() == 2 && this.isTree()) {
            try {
                return RawParseUtils.parseHexInt4(this.path[this.pathOffset + 0]) << 4 | RawParseUtils.parseHexInt4(this.path[this.pathOffset + 1]);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return -1;
            }
        }
        return -1;
    }

    private void storeNonNote() {
        ObjectId objectId = this.getEntryObjectId();
        FileMode fileMode = this.getEntryFileMode();
        byte[] byArray = new byte[this.getNameLength()];
        this.getName(byArray, 0);
        NonNoteEntry nonNoteEntry = new NonNoteEntry(byArray, fileMode, objectId);
        if (this.firstNonNote == null) {
            this.firstNonNote = nonNoteEntry;
        }
        if (this.lastNonNote != null) {
            this.lastNonNote.next = nonNoteEntry;
        }
        this.lastNonNote = nonNoteEntry;
    }

    private boolean isTree() {
        return FileMode.TREE.equals(this.mode);
    }

    private boolean isHex() {
        try {
            for (int i2 = this.pathOffset; i2 < this.pathLen; ++i2) {
                RawParseUtils.parseHexInt4(this.path[i2]);
            }
            return true;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return false;
        }
    }
}

