/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.notes;

import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.merge.Merger;
import org.eclipse.jgit.merge.ThreeWayMerger;
import org.eclipse.jgit.notes.DefaultNoteMerger;
import org.eclipse.jgit.notes.FanoutBucket;
import org.eclipse.jgit.notes.InMemoryNoteBucket;
import org.eclipse.jgit.notes.LeafBucket;
import org.eclipse.jgit.notes.NonNoteEntry;
import org.eclipse.jgit.notes.Note;
import org.eclipse.jgit.notes.NoteBucket;
import org.eclipse.jgit.notes.NoteMap;
import org.eclipse.jgit.notes.NoteMerger;
import org.eclipse.jgit.notes.NoteParser;
import org.eclipse.jgit.notes.NotesMergeConflictException;

public class NoteMapMerger {
    private static final FanoutBucket EMPTY_FANOUT = new FanoutBucket(0);
    private static final LeafBucket EMPTY_LEAF = new LeafBucket(0);
    private final Repository db;
    private final NoteMerger noteMerger;
    private final MergeStrategy nonNotesMergeStrategy;
    private final ObjectReader reader;
    private final ObjectInserter inserter;
    private final MutableObjectId objectIdPrefix;

    public NoteMapMerger(Repository repository, NoteMerger noteMerger, MergeStrategy mergeStrategy) {
        this.db = repository;
        this.reader = repository.newObjectReader();
        this.inserter = repository.newObjectInserter();
        this.noteMerger = noteMerger;
        this.nonNotesMergeStrategy = mergeStrategy;
        this.objectIdPrefix = new MutableObjectId();
    }

    public NoteMapMerger(Repository repository) {
        this(repository, new DefaultNoteMerger(), MergeStrategy.RESOLVE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NoteMap merge(NoteMap noteMap, NoteMap noteMap2, NoteMap noteMap3) {
        try {
            InMemoryNoteBucket inMemoryNoteBucket = this.merge(0, noteMap.getRoot(), noteMap2.getRoot(), noteMap3.getRoot());
            this.inserter.flush();
            NoteMap noteMap4 = NoteMap.newMap(inMemoryNoteBucket, this.reader);
            return noteMap4;
        }
        finally {
            this.reader.close();
            this.inserter.close();
        }
    }

    private InMemoryNoteBucket merge(int n2, InMemoryNoteBucket inMemoryNoteBucket, InMemoryNoteBucket inMemoryNoteBucket2, InMemoryNoteBucket inMemoryNoteBucket3) {
        InMemoryNoteBucket inMemoryNoteBucket4 = inMemoryNoteBucket instanceof FanoutBucket || inMemoryNoteBucket2 instanceof FanoutBucket || inMemoryNoteBucket3 instanceof FanoutBucket ? this.mergeFanoutBucket(n2, this.asFanout(inMemoryNoteBucket), this.asFanout(inMemoryNoteBucket2), this.asFanout(inMemoryNoteBucket3)) : this.mergeLeafBucket(n2, (LeafBucket)inMemoryNoteBucket, (LeafBucket)inMemoryNoteBucket2, (LeafBucket)inMemoryNoteBucket3);
        inMemoryNoteBucket4.nonNotes = this.mergeNonNotes(NoteMapMerger.nonNotes(inMemoryNoteBucket), NoteMapMerger.nonNotes(inMemoryNoteBucket2), NoteMapMerger.nonNotes(inMemoryNoteBucket3));
        return inMemoryNoteBucket4;
    }

    private FanoutBucket asFanout(InMemoryNoteBucket inMemoryNoteBucket) {
        if (inMemoryNoteBucket == null) {
            return EMPTY_FANOUT;
        }
        if (inMemoryNoteBucket instanceof FanoutBucket) {
            return (FanoutBucket)inMemoryNoteBucket;
        }
        return ((LeafBucket)inMemoryNoteBucket).split();
    }

    private static NonNoteEntry nonNotes(InMemoryNoteBucket inMemoryNoteBucket) {
        return inMemoryNoteBucket == null ? null : inMemoryNoteBucket.nonNotes;
    }

    private InMemoryNoteBucket mergeFanoutBucket(int n2, FanoutBucket fanoutBucket, FanoutBucket fanoutBucket2, FanoutBucket fanoutBucket3) {
        FanoutBucket fanoutBucket4 = new FanoutBucket(n2 * 2);
        for (int i2 = 0; i2 < 256; ++i2) {
            NoteBucket noteBucket;
            NoteBucket noteBucket2 = fanoutBucket.getBucket(i2);
            NoteBucket noteBucket3 = fanoutBucket2.getBucket(i2);
            if (NoteMapMerger.equals(noteBucket3, noteBucket = fanoutBucket3.getBucket(i2))) {
                this.addIfNotNull(fanoutBucket4, i2, noteBucket3);
                continue;
            }
            if (NoteMapMerger.equals(noteBucket2, noteBucket3)) {
                this.addIfNotNull(fanoutBucket4, i2, noteBucket);
                continue;
            }
            if (NoteMapMerger.equals(noteBucket2, noteBucket)) {
                this.addIfNotNull(fanoutBucket4, i2, noteBucket3);
                continue;
            }
            this.objectIdPrefix.setByte(n2, i2);
            InMemoryNoteBucket inMemoryNoteBucket = this.merge(n2 + 1, FanoutBucket.loadIfLazy(noteBucket2, this.objectIdPrefix, this.reader), FanoutBucket.loadIfLazy(noteBucket3, this.objectIdPrefix, this.reader), FanoutBucket.loadIfLazy(noteBucket, this.objectIdPrefix, this.reader));
            fanoutBucket4.setBucket(i2, inMemoryNoteBucket);
        }
        return fanoutBucket4.contractIfTooSmall(this.objectIdPrefix, this.reader);
    }

    private static boolean equals(NoteBucket noteBucket, NoteBucket noteBucket2) {
        if (noteBucket == null && noteBucket2 == null) {
            return true;
        }
        return noteBucket != null && noteBucket2 != null && noteBucket.getTreeId().equals(noteBucket2.getTreeId());
    }

    private void addIfNotNull(FanoutBucket fanoutBucket, int n2, NoteBucket noteBucket) {
        if (noteBucket == null) {
            return;
        }
        if (noteBucket instanceof InMemoryNoteBucket) {
            fanoutBucket.setBucket(n2, ((InMemoryNoteBucket)noteBucket).writeTree(this.inserter));
        } else {
            fanoutBucket.setBucket(n2, noteBucket.getTreeId());
        }
    }

    private InMemoryNoteBucket mergeLeafBucket(int n2, LeafBucket leafBucket, LeafBucket leafBucket2, LeafBucket leafBucket3) {
        leafBucket = NoteMapMerger.notNullOrEmpty(leafBucket);
        leafBucket2 = NoteMapMerger.notNullOrEmpty(leafBucket2);
        leafBucket3 = NoteMapMerger.notNullOrEmpty(leafBucket3);
        InMemoryNoteBucket inMemoryNoteBucket = new LeafBucket(n2 * 2);
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n3 < leafBucket.size() || n4 < leafBucket2.size() || n5 < leafBucket3.size()) {
            Note note = NoteMapMerger.get(leafBucket, n3);
            Note note2 = NoteMapMerger.get(leafBucket2, n4);
            Note note3 = NoteMapMerger.get(leafBucket3, n5);
            Note note4 = NoteMapMerger.min(note, note2, note3);
            note = NoteMapMerger.sameNoteOrNull(note4, note);
            inMemoryNoteBucket = NoteMapMerger.sameContent(note2 = NoteMapMerger.sameNoteOrNull(note4, note2), note3 = NoteMapMerger.sameNoteOrNull(note4, note3)) ? NoteMapMerger.addIfNotNull(inMemoryNoteBucket, note2) : (NoteMapMerger.sameContent(note, note2) ? NoteMapMerger.addIfNotNull(inMemoryNoteBucket, note3) : (NoteMapMerger.sameContent(note, note3) ? NoteMapMerger.addIfNotNull(inMemoryNoteBucket, note2) : NoteMapMerger.addIfNotNull(inMemoryNoteBucket, this.noteMerger.merge(note, note2, note3, this.reader, this.inserter))));
            if (note != null) {
                ++n3;
            }
            if (note2 != null) {
                ++n4;
            }
            if (note3 == null) continue;
            ++n5;
        }
        return inMemoryNoteBucket;
    }

    private static LeafBucket notNullOrEmpty(LeafBucket leafBucket) {
        return leafBucket != null ? leafBucket : EMPTY_LEAF;
    }

    private static Note get(LeafBucket leafBucket, int n2) {
        return n2 < leafBucket.size() ? leafBucket.get(n2) : null;
    }

    private static Note min(Note note, Note note2, Note note3) {
        Note note4 = note;
        if (note4 == null || note2 != null && note2.compareTo(note4) < 0) {
            note4 = note2;
        }
        if (note4 == null || note3 != null && note3.compareTo(note4) < 0) {
            note4 = note3;
        }
        return note4;
    }

    private static Note sameNoteOrNull(Note note, Note note2) {
        return NoteMapMerger.sameNote(note, note2) ? note2 : null;
    }

    private static boolean sameNote(Note note, Note note2) {
        if (note == null && note2 == null) {
            return true;
        }
        return note != null && note2 != null && AnyObjectId.isEqual(note, note2);
    }

    private static boolean sameContent(Note note, Note note2) {
        if (note == null && note2 == null) {
            return true;
        }
        return note != null && note2 != null && AnyObjectId.isEqual(note.getData(), note2.getData());
    }

    private static InMemoryNoteBucket addIfNotNull(InMemoryNoteBucket inMemoryNoteBucket, Note note) {
        if (note != null) {
            return inMemoryNoteBucket.append(note);
        }
        return inMemoryNoteBucket;
    }

    private NonNoteEntry mergeNonNotes(NonNoteEntry nonNoteEntry, NonNoteEntry nonNoteEntry2, NonNoteEntry nonNoteEntry3) {
        if (nonNoteEntry == null && nonNoteEntry2 == null && nonNoteEntry3 == null) {
            return null;
        }
        ObjectId objectId = this.write(nonNoteEntry);
        ObjectId objectId2 = this.write(nonNoteEntry2);
        ObjectId objectId3 = this.write(nonNoteEntry3);
        this.inserter.flush();
        Merger merger = this.nonNotesMergeStrategy.newMerger(this.db, true);
        if (merger instanceof ThreeWayMerger) {
            ((ThreeWayMerger)merger).setBase(objectId);
        }
        if (!merger.merge(objectId2, objectId3)) {
            throw new NotesMergeConflictException(nonNoteEntry, nonNoteEntry2, nonNoteEntry3);
        }
        ObjectId objectId4 = merger.getResultTreeId();
        AbbreviatedObjectId abbreviatedObjectId = AbbreviatedObjectId.fromString("");
        return NoteParser.parse((AbbreviatedObjectId)abbreviatedObjectId, (ObjectId)objectId4, (ObjectReader)this.reader).nonNotes;
    }

    private ObjectId write(NonNoteEntry nonNoteEntry) {
        LeafBucket leafBucket = new LeafBucket(0);
        leafBucket.nonNotes = nonNoteEntry;
        return leafBucket.writeTree(this.inserter);
    }
}

