/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.notes;

import java.io.IOException;
import java.util.Iterator;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.notes.InMemoryNoteBucket;
import org.eclipse.jgit.notes.LeafBucket;
import org.eclipse.jgit.notes.Note;
import org.eclipse.jgit.notes.NoteParser;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;

public class NoteMap
implements Iterable {
    private final ObjectReader reader;
    private InMemoryNoteBucket root;

    public static NoteMap newEmptyMap() {
        NoteMap noteMap = new NoteMap(null);
        noteMap.root = new LeafBucket(0);
        return noteMap;
    }

    public static String shortenRefName(String string) {
        if (string.startsWith("refs/notes/")) {
            return string.substring("refs/notes/".length());
        }
        return string;
    }

    public static NoteMap read(ObjectReader objectReader, RevCommit revCommit) {
        return NoteMap.read(objectReader, revCommit.getTree());
    }

    public static NoteMap read(ObjectReader objectReader, RevTree revTree) {
        return NoteMap.readTree(objectReader, revTree);
    }

    public static NoteMap readTree(ObjectReader objectReader, ObjectId objectId) {
        NoteMap noteMap = new NoteMap(objectReader);
        noteMap.load(objectId);
        return noteMap;
    }

    static NoteMap newMap(InMemoryNoteBucket inMemoryNoteBucket, ObjectReader objectReader) {
        NoteMap noteMap = new NoteMap(objectReader);
        noteMap.root = inMemoryNoteBucket;
        return noteMap;
    }

    private NoteMap(ObjectReader objectReader) {
        this.reader = objectReader;
    }

    public Iterator iterator() {
        try {
            return this.root.iterator(new MutableObjectId(), this.reader);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public ObjectId get(AnyObjectId anyObjectId) {
        Note note = this.root.getNote(anyObjectId, this.reader);
        return note == null ? null : note.getData();
    }

    public Note getNote(AnyObjectId anyObjectId) {
        return this.root.getNote(anyObjectId, this.reader);
    }

    public boolean contains(AnyObjectId anyObjectId) {
        return this.get(anyObjectId) != null;
    }

    public byte[] getCachedBytes(AnyObjectId anyObjectId, int n2) {
        ObjectId objectId = this.get(anyObjectId);
        if (objectId != null) {
            return this.reader.open(objectId).getCachedBytes(n2);
        }
        return null;
    }

    public void set(AnyObjectId anyObjectId, ObjectId objectId) {
        InMemoryNoteBucket inMemoryNoteBucket = this.root.set(anyObjectId, objectId, this.reader);
        if (inMemoryNoteBucket == null) {
            inMemoryNoteBucket = new LeafBucket(0);
            inMemoryNoteBucket.nonNotes = this.root.nonNotes;
        }
        this.root = inMemoryNoteBucket;
    }

    public void set(AnyObjectId anyObjectId, String string, ObjectInserter objectInserter) {
        ObjectId objectId;
        if (string != null) {
            byte[] byArray = Constants.encode(string);
            objectId = objectInserter.insert(3, byArray);
        } else {
            objectId = null;
        }
        this.set(anyObjectId, objectId);
    }

    public void remove(AnyObjectId anyObjectId) {
        this.set(anyObjectId, null);
    }

    public ObjectId writeTree(ObjectInserter objectInserter) {
        return this.root.writeTree(objectInserter);
    }

    InMemoryNoteBucket getRoot() {
        return this.root;
    }

    private void load(ObjectId objectId) {
        AbbreviatedObjectId abbreviatedObjectId = AbbreviatedObjectId.fromString("");
        this.root = NoteParser.parse(abbreviatedObjectId, objectId, this.reader);
    }
}

