/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.notes;

import java.util.Iterator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectInserter$Formatter;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.TreeFormatter;
import org.eclipse.jgit.notes.FanoutBucket;
import org.eclipse.jgit.notes.InMemoryNoteBucket;
import org.eclipse.jgit.notes.LeafBucket$1;
import org.eclipse.jgit.notes.NonNoteEntry;
import org.eclipse.jgit.notes.Note;

class LeafBucket
extends InMemoryNoteBucket {
    static final int MAX_SIZE = 256;
    private Note[] notes = new Note[4];
    private int cnt;

    LeafBucket(int n2) {
        super(n2);
    }

    private int search(AnyObjectId anyObjectId) {
        int n2 = 0;
        int n3 = this.cnt;
        while (n2 < n3) {
            int n4 = n2 + n3 >>> 1;
            int n5 = anyObjectId.compareTo(this.notes[n4]);
            if (n5 < 0) {
                n3 = n4;
                continue;
            }
            if (n5 == 0) {
                return n4;
            }
            n2 = n4 + 1;
        }
        return -(n2 + 1);
    }

    @Override
    Note getNote(AnyObjectId anyObjectId, ObjectReader objectReader) {
        int n2 = this.search(anyObjectId);
        return 0 <= n2 ? this.notes[n2] : null;
    }

    Note get(int n2) {
        return this.notes[n2];
    }

    int size() {
        return this.cnt;
    }

    @Override
    Iterator iterator(AnyObjectId anyObjectId, ObjectReader objectReader) {
        return new LeafBucket$1(this);
    }

    @Override
    int estimateSize(AnyObjectId anyObjectId, ObjectReader objectReader) {
        return this.cnt;
    }

    @Override
    InMemoryNoteBucket set(AnyObjectId anyObjectId, AnyObjectId anyObjectId2, ObjectReader objectReader) {
        int n2 = this.search(anyObjectId);
        if (0 <= n2) {
            if (anyObjectId2 != null) {
                this.notes[n2].setData(anyObjectId2.copy());
                return this;
            }
            System.arraycopy(this.notes, n2 + 1, this.notes, n2, this.cnt - n2 - 1);
            --this.cnt;
            return 0 < this.cnt ? this : null;
        }
        if (anyObjectId2 != null) {
            if (this.shouldSplit()) {
                return this.split().set(anyObjectId, anyObjectId2, objectReader);
            }
            this.growIfFull();
            n2 = -(n2 + 1);
            if (n2 < this.cnt) {
                System.arraycopy(this.notes, n2, this.notes, n2 + 1, this.cnt - n2);
            }
            this.notes[n2] = new Note(anyObjectId, anyObjectId2.copy());
            ++this.cnt;
            return this;
        }
        return this;
    }

    @Override
    ObjectId writeTree(ObjectInserter objectInserter) {
        return objectInserter.insert(this.build());
    }

    @Override
    ObjectId getTreeId() {
        try (ObjectInserter$Formatter objectInserter$Formatter = new ObjectInserter$Formatter();){
            ObjectId objectId = objectInserter$Formatter.idFor(this.build());
            return objectId;
        }
    }

    private TreeFormatter build() {
        byte[] byArray = new byte[40];
        int n2 = 40 - this.prefixLen;
        TreeFormatter treeFormatter = new TreeFormatter(this.treeSize(n2));
        NonNoteEntry nonNoteEntry = this.nonNotes;
        for (int i2 = 0; i2 < this.cnt; ++i2) {
            Note note = this.notes[i2];
            note.copyTo(byArray, 0);
            while (nonNoteEntry != null && nonNoteEntry.pathCompare(byArray, this.prefixLen, n2, FileMode.REGULAR_FILE) < 0) {
                nonNoteEntry.format(treeFormatter);
                nonNoteEntry = nonNoteEntry.next;
            }
            treeFormatter.append(byArray, this.prefixLen, n2, FileMode.REGULAR_FILE, note.getData());
        }
        while (nonNoteEntry != null) {
            nonNoteEntry.format(treeFormatter);
            nonNoteEntry = nonNoteEntry.next;
        }
        return treeFormatter;
    }

    private int treeSize(int n2) {
        int n3 = this.cnt * TreeFormatter.entrySize(FileMode.REGULAR_FILE, n2);
        NonNoteEntry nonNoteEntry = this.nonNotes;
        while (nonNoteEntry != null) {
            n3 += nonNoteEntry.treeEntrySize();
            nonNoteEntry = nonNoteEntry.next;
        }
        return n3;
    }

    void parseOneEntry(AnyObjectId anyObjectId, AnyObjectId anyObjectId2) {
        this.growIfFull();
        this.notes[this.cnt++] = new Note(anyObjectId, anyObjectId2.copy());
    }

    @Override
    InMemoryNoteBucket append(Note note) {
        if (this.shouldSplit()) {
            return this.split().append(note);
        }
        this.growIfFull();
        this.notes[this.cnt++] = note;
        return this;
    }

    private void growIfFull() {
        if (this.notes.length == this.cnt) {
            Note[] noteArray = new Note[this.notes.length * 2];
            System.arraycopy(this.notes, 0, noteArray, 0, this.cnt);
            this.notes = noteArray;
        }
    }

    private boolean shouldSplit() {
        return 256 <= this.cnt && this.prefixLen + 2 < 40;
    }

    FanoutBucket split() {
        FanoutBucket fanoutBucket = new FanoutBucket(this.prefixLen);
        for (int i2 = 0; i2 < this.cnt; ++i2) {
            fanoutBucket.append(this.notes[i2]);
        }
        fanoutBucket.nonNotes = this.nonNotes;
        return fanoutBucket;
    }

    static /* synthetic */ int access$000(LeafBucket leafBucket) {
        return leafBucket.cnt;
    }

    static /* synthetic */ Note[] access$100(LeafBucket leafBucket) {
        return leafBucket.notes;
    }
}

